<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Expense;
use Illuminate\Http\Request;

class ExpenseController extends Controller
{
    public function index()
    {
        $expenses = Expense::with('user')->latest()->paginate(15);
        return view('admin.expenses.index', compact('expenses'));
    }

    public function updateStatus(Request $request, Expense $expense)
    {
        $request->validate(['status' => 'required|in:approved,rejected']);
        
        $expense->update(['status' => $request->status]);
        
        return back()->with('success', 'Expense status updated!');
    }
}
