<?php

namespace App\Http\Controllers\Sales;

use App\Http\Controllers\Controller;
use App\Models\Commission;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CommissionController extends Controller
{
    public function index()
    {
        $commissions = Commission::where('sales_rep_id', Auth::id())
            ->with(['sale.customer'])
            ->latest()
            ->paginate(15);
        
        $totalCommission = Commission::where('sales_rep_id', Auth::id())
            ->where('status', 'pending')
            ->sum('commission_amount');

        return view('sales.commissions.index', compact('commissions', 'totalCommission'));
    }
}
