<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Payroll extends Model
{
    protected $fillable = [
        'user_id',
        'month',
        'payment_date',
        'basic_salary',
        'total_commission',
        'gross_salary',
        'epf_employee',
        'etf_employee',
        'epf_employer',
        'etf_employer',
        'salary_advance_deduction',
        'loan_deduction',
        'other_deductions',
        'total_deductions',
        'net_salary',
        'status',
        'notes',
    ];

    protected $casts = [
        'payment_date' => 'date',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
