<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductPriceLevel extends Model
{
    use HasFactory;

    protected $fillable = ['product_pack_size_id', 'price_level', 'price', 'is_active'];

    protected $casts = [
        'is_active' => 'boolean',
        'price' => 'decimal:2',
    ];

    public function packSize()
    {
        return $this->belongsTo(ProductPackSize::class, 'product_pack_size_id');
    }
}
