<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SalaryAdvance extends Model
{
    protected $fillable = [
        'user_id',
        'amount',
        'advance_date',
        'deducted_amount',
        'remaining_amount',
        'status',
        'reason',
        'approved_by',
    ];

    protected $casts = [
        'advance_date' => 'date',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function approver()
    {
        return $this->belongsTo(User::class, 'approved_by');
    }
}
