<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable, \Illuminate\Database\Eloquent\SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'role_id',
        'vehicle_id',
        'mobile',
        'address',
        'commission_cash',
        'commission_credit',
        'commission_credit',
        'commission_cheque',
        'basic_salary',
        'epf_number',
        'etf_number',
        'bank_name',
        'bank_account_number',
        'bank_branch',
        'is_active',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
            'is_active' => 'boolean',
        ];
    }

    public function role()
    {
        return $this->belongsTo(Role::class);
    }

    public function vehicle()
    {
        return $this->belongsTo(Vehicle::class);
    }

    public function isAdmin()
    {
        return $this->role && $this->role->name === 'Admin';
    }

    public function isSalesRep()
    {
        return $this->role && $this->role->name === 'Sales Representative';
    }

    public function isDriver()
    {
        return $this->role && $this->role->name === 'Driver';
    }

    public function driverDeliveries()
    {
        return $this->hasMany(Delivery::class, 'driver_id');
    }

    public function repDeliveries()
    {
        return $this->hasMany(Delivery::class, 'sales_rep_id');
    }

    public function payrolls()
    {
        return $this->hasMany(Payroll::class);
    }

    public function salaryAdvances()
    {
        return $this->hasMany(SalaryAdvance::class);
    }

    public function loans()
    {
        return $this->hasMany(Loan::class);
    }
}
