<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description')->nullable();
            $table->string('image')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::create('product_pack_sizes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('product_id')->constrained()->onDelete('cascade');
            $table->string('size_name'); // e.g., 'Unit', 'Carton'
            $table->integer('quantity'); // e.g., 1, 10
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::create('product_price_levels', function (Blueprint $table) {
            $table->id();
            $table->foreignId('product_pack_size_id')->constrained('product_pack_sizes')->onDelete('cascade');
            $table->string('price_level'); // 'retail', 'wholesale', 'distributor', 'special'
            $table->decimal('price', 12, 2);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('product_price_levels');
        Schema::dropIfExists('product_pack_sizes');
        Schema::dropIfExists('products');
    }
};
