<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // 1. Stocks Table (Tracks current inventory level per product in base units)
        Schema::create('stocks', function (Blueprint $table) {
            $table->id();
            $table->foreignId('product_id')->constrained()->onDelete('cascade');
            $table->decimal('quantity', 12, 2)->default(0); // quantity in base units
            $table->timestamps();
        });

        // 2. GRN Tables (Goods Received Note - for adding stock)
        Schema::create('grns', function (Blueprint $table) {
            $table->id();
            $table->string('grn_number')->unique(); // e.g., GRN-2026-001
            $table->string('supplier_name')->nullable();
            $table->date('received_date');
            $table->decimal('total_amount', 12, 2)->default(0);
            $table->text('notes')->nullable();
            $table->foreignId('created_by')->constrained('users'); // Admin who created it
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::create('grn_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('grn_id')->constrained()->onDelete('cascade');
            $table->foreignId('product_id')->constrained();
            $table->foreignId('product_pack_size_id')->nullable()->constrained('product_pack_sizes'); // e.g., Receiving 10 Cartons
            
            $table->decimal('quantity', 12, 2); // Qty of the pack size (e.g., 10)
            $table->decimal('cost_price', 12, 2); // Cost per pack size unit
            $table->decimal('total_cost', 12, 2);
            
            $table->timestamps();
        });

        // 3. Expenses Table (For Sales Reps)
        Schema::create('expenses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade'); // The Rep
            $table->string('category'); // Fuel, Meal, Maintenance, Other
            $table->decimal('amount', 12, 2);
            $table->text('description')->nullable();
            $table->date('expense_date');
            $table->string('status')->default('pending'); // pending, approved, rejected
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('expenses');
        Schema::dropIfExists('grn_items');
        Schema::dropIfExists('grns');
        Schema::dropIfExists('stocks');
    }
};
