<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('epf_number')->nullable()->after('basic_salary');
            $table->string('etf_number')->nullable()->after('epf_number');
            $table->string('bank_name')->nullable()->after('etf_number');
            $table->string('bank_account_number')->nullable()->after('bank_name');
            $table->string('bank_branch')->nullable()->after('bank_account_number');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['epf_number', 'etf_number', 'bank_name', 'bank_account_number', 'bank_branch']);
        });
    }
};
