<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payrolls', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('month'); // e.g., '2026-02'
            $table->date('payment_date');
            
            // Salary components
            $table->decimal('basic_salary', 12, 2)->default(0);
            $table->decimal('total_commission', 12, 2)->default(0);
            $table->decimal('gross_salary', 12, 2)->default(0); // basic + commission
            
            // EPF/ETF Deductions (Employee)
            $table->decimal('epf_employee', 12, 2)->default(0); // 8% of gross
            $table->decimal('etf_employee', 12, 2)->default(0); // 3% of gross
            
            // EPF/ETF Contributions (Employer)
            $table->decimal('epf_employer', 12, 2)->default(0); // 12% of gross
            $table->decimal('etf_employer', 12, 2)->default(0); // 3% of gross (same as employee)
            
            // Other deductions
            $table->decimal('salary_advance_deduction', 12, 2)->default(0);
            $table->decimal('loan_deduction', 12, 2)->default(0);
            $table->decimal('other_deductions', 12, 2)->default(0);
            $table->decimal('total_deductions', 12, 2)->default(0);
            
            // Net salary
            $table->decimal('net_salary', 12, 2)->default(0);
            
            $table->enum('status', ['pending', 'processed', 'paid'])->default('pending');
            $table->text('notes')->nullable();
            $table->timestamps();
            
            // Unique constraint to prevent duplicate payroll for same user and month
            $table->unique(['user_id', 'month']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payrolls');
    }
};
