<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class CommissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $reps = \App\Models\User::whereHas('role', function($q) {
            $q->where('name', 'Sales Representative');
        })->get();

        foreach ($reps as $rep) {
            $rep->commission_cash = 5.0;
            $rep->commission_credit = 2.0;
            $rep->commission_cheque = 2.0;
            $rep->save();
        }
    }
}
