<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Add New Stock (Create GRN)') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <form action="{{ route('admin.inventory.grn.store') }}" method="POST">
                        @csrf
                        <div class="grid grid-cols-2 gap-4 mb-4">
                            <div>
                                <x-input-label for="supplier_name" :value="__('Supplier Name')" />
                                <x-text-input id="supplier_name" class="block mt-1 w-full" type="text" name="supplier_name" required autofocus />
                            </div>
                            <div>
                                <x-input-label for="received_date" :value="__('Received Date')" />
                                <x-text-input id="received_date" class="block mt-1 w-full" type="date" name="received_date" :value="date('Y-m-d')" required />
                            </div>
                            <div class="col-span-2">
                                <x-input-label for="notes" :value="__('Notes')" />
                                <textarea id="notes" name="notes" class="block mt-1 w-full border-gray-300 rounded-md shadow-sm"></textarea>
                            </div>
                        </div>

                        <h3 class="text-lg font-medium mb-2">Items</h3>
                        <div id="items-container">
                            <div class="grid grid-cols-4 gap-4 mb-2 item-row">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Product</label>
                                    <select name="items[0][product_id]" class="block mt-1 w-full border-gray-300 rounded-md shadow-sm product-select" onchange="updatePackSizes(this)">
                                        <option value="">Select Product...</option>
                                        @foreach($products as $product)
                                            <option value="{{ $product->id }}" data-packs="{{ json_encode($product->packSizes) }}">{{ $product->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Pack Size</label>
                                    <select name="items[0][product_pack_size_id]" class="block mt-1 w-full border-gray-300 rounded-md shadow-sm pack-select">
                                        <option value="">Select Pack Size...</option>
                                    </select>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Quantity Entered</label>
                                    <input type="number" name="items[0][quantity]" class="block mt-1 w-full border-gray-300 rounded-md shadow-sm" placeholder="Qty" required step="1">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Unit Cost</label>
                                    <input type="number" name="items[0][cost_price]" class="block mt-1 w-full border-gray-300 rounded-md shadow-sm" placeholder="Cost Price" required step="0.01">
                                </div>
                            </div>
                        </div>

                        <button type="button" onclick="addItemRow()" class="mt-2 text-sm text-blue-600 hover:text-blue-900">+ Add Another Item</button>

                        <div class="mt-6">
                            <x-primary-button>
                                {{ __('Create GRN & Update Stock') }}
                            </x-primary-button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        let itemCount = 1;

        function updatePackSizes(selectElement) {
            const row = selectElement.closest('.item-row');
            const packSelect = row.querySelector('.pack-select');
            const selectedOption = selectElement.options[selectElement.selectedIndex];
            const packs = JSON.parse(selectedOption.getAttribute('data-packs') || '[]');

            packSelect.innerHTML = '<option value="">Select Pack Size...</option>';
            packs.forEach(pack => {
                const option = document.createElement('option');
                option.value = pack.id;
                option.text = pack.size_name + ' (x' + pack.quantity + ')';
                packSelect.appendChild(option);
            });
        }

        function addItemRow() {
            // Simplified cloning for this demo (ideally would use a more robust template)
            const container = document.getElementById('items-container');
            const firstRow = container.querySelector('.item-row');
            const newRow = firstRow.cloneNode(true);
            
            // Clear values
            newRow.querySelectorAll('input').forEach(input => input.value = '');
            newRow.querySelectorAll('select').forEach(select => select.selectedIndex = 0);
            
            // Update names
            newRow.querySelectorAll('[name]').forEach(el => {
                el.name = el.name.replace(/\[\d+\]/, '[' + itemCount + ']');
            });

            container.appendChild(newRow);
            itemCount++;
        }
    </script>
</x-app-layout>
