<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Vehicle Stocks') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    @foreach($vehicles as $vehicle)
                        <div class="mb-8 border-b pb-4">
                            <h3 class="text-lg font-bold mb-2 text-blue-800">{{ $vehicle->truck_number }} ({{ $vehicle->driver_name }})</h3>
                            
                            @if($vehicle->stocks->isEmpty() || $vehicle->stocks->sum('quantity') == 0)
                                <p class="text-gray-500 italic">No stock loaded.</p>
                            @else
                                <table class="min-w-full leading-normal">
                                    <thead>
                                        <tr>
                                            <th class="px-5 py-3 border-b-2 border-gray-200 bg-gray-50 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Product</th>
                                            <th class="px-5 py-3 border-b-2 border-gray-200 bg-gray-50 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Base Quantity</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($vehicle->stocks as $stock)
                                            @if($stock->quantity > 0)
                                            <tr>
                                                <td class="px-5 py-3 border-b border-gray-200 bg-white text-sm">{{ $stock->product->name }}</td>
                                                <td class="px-5 py-3 border-b border-gray-200 bg-white text-sm font-bold">{{ $stock->quantity }}</td>
                                            </tr>
                                            @endif
                                        @endforeach
                                    </tbody>
                                </table>
                            @endif
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
