<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Create Employee Loan') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-3xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <form method="POST" action="{{ route('admin.loans.store') }}">
                        @csrf

                        <div class="space-y-4">
                            <div>
                                <label for="user_id" class="block text-sm font-medium text-gray-700 mb-1">
                                    Employee <span class="text-red-500">*</span>
                                </label>
                                <select id="user_id" name="user_id" required
                                        class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                    <option value="">Select Employee</option>
                                    @foreach($users as $user)
                                        <option value="{{ $user->id }}" {{ old('user_id') == $user->id ? 'selected' : '' }}>
                                            {{ $user->name }} ({{ $user->email }})
                                        </option>
                                    @endforeach
                                </select>
                                @error('user_id')
                                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                @enderror
                            </div>

                            <div>
                                <label for="total_amount" class="block text-sm font-medium text-gray-700 mb-1">
                                    Total Loan Amount (Rs.) <span class="text-red-500">*</span>
                                </label>
                                <input type="number" 
                                       id="total_amount" 
                                       name="total_amount" 
                                       step="0.01"
                                       min="0"
                                       value="{{ old('total_amount') }}"
                                       required
                                       oninput="calculateInstallment()"
                                       class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                       placeholder="0.00">
                                @error('total_amount')
                                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                @enderror
                            </div>

                            <div>
                                <label for="total_installments" class="block text-sm font-medium text-gray-700 mb-1">
                                    Number of Installments (Months) <span class="text-red-500">*</span>
                                </label>
                                <input type="number" 
                                       id="total_installments" 
                                       name="total_installments" 
                                       min="1"
                                       value="{{ old('total_installments', 12) }}"
                                       required
                                       oninput="calculateInstallment()"
                                       class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                       placeholder="12">
                                @error('total_installments')
                                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="p-4 bg-blue-50 rounded">
                                <div class="text-sm text-blue-800">
                                    <strong>Monthly Installment:</strong> 
                                    <span id="monthly_installment" class="text-lg font-bold">Rs. 0.00</span>
                                </div>
                            </div>

                            <div>
                                <label for="loan_date" class="block text-sm font-medium text-gray-700 mb-1">
                                    Loan Date <span class="text-red-500">*</span>
                                </label>
                                <input type="date" 
                                       id="loan_date" 
                                       name="loan_date" 
                                       value="{{ old('loan_date', now()->format('Y-m-d')) }}"
                                       required
                                       class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                @error('loan_date')
                                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                @enderror
                            </div>

                            <div>
                                <label for="start_deduction_date" class="block text-sm font-medium text-gray-700 mb-1">
                                    Start Deduction Date <span class="text-red-500">*</span>
                                </label>
                                <input type="date" 
                                       id="start_deduction_date" 
                                       name="start_deduction_date" 
                                       value="{{ old('start_deduction_date', now()->addMonth()->format('Y-m-d')) }}"
                                       required
                                       class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                <p class="text-xs text-gray-500 mt-1">The date when monthly deductions should begin</p>
                                @error('start_deduction_date')
                                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                @enderror
                            </div>

                            <div>
                                <label for="purpose" class="block text-sm font-medium text-gray-700 mb-1">
                                    Purpose (Optional)
                                </label>
                                <textarea id="purpose" 
                                          name="purpose" 
                                          rows="3"
                                          class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                          placeholder="Enter purpose of the loan">{{ old('purpose') }}</textarea>
                                @error('purpose')
                                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="p-4 bg-yellow-50 rounded">
                                <p class="text-sm text-yellow-800">
                                    <strong>Note:</strong> The monthly installment will be automatically deducted from the employee's salary each month starting from the specified deduction date.
                                </p>
                            </div>

                            <div class="flex gap-3 pt-4">
                                <button type="submit" 
                                        class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-md">
                                    Create Loan
                                </button>
                                <a href="{{ route('admin.loans.index') }}" 
                                   class="bg-gray-600 hover:bg-gray-700 text-white px-6 py-2 rounded-md">
                                    Cancel
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        function calculateInstallment() {
            const totalAmount = parseFloat(document.getElementById('total_amount').value) || 0;
            const installments = parseInt(document.getElementById('total_installments').value) || 1;
            const monthlyInstallment = totalAmount / installments;
            
            document.getElementById('monthly_installment').textContent = 
                'Rs. ' + monthlyInstallment.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ',');
        }

        // Calculate on page load
        calculateInstallment();
    </script>
</x-app-layout>
