<x-app-layout>
    <x-slot name="header">
        <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
            <div>
                <h2 class="font-bold text-2xl text-gray-900 leading-tight">
                    🏦 Employee Loans
                </h2>
                <p class="text-sm text-gray-600 mt-1">Manage employee loans and track repayment progress</p>
            </div>
            <a href="{{ route('admin.loans.create') }}" 
               class="inline-flex items-center px-4 py-2 bg-gradient-to-r from-indigo-600 to-indigo-700 hover:from-indigo-700 hover:to-indigo-800 text-white text-sm font-medium rounded-lg shadow-lg transition-all duration-200 hover:shadow-xl transform hover:-translate-y-0.5">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                </svg>
                New Loan
            </a>
        </div>
    </x-slot>

    <div class="py-6 sm:py-12">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            @if(session('success'))
                <div class="mb-6 bg-gradient-to-r from-green-50 to-emerald-50 border-l-4 border-green-500 text-green-800 px-4 py-3 rounded-lg shadow-sm animate-fade-in">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                        </svg>
                        {{ session('success') }}
                    </div>
                </div>
            @endif

            @if(session('error'))
                <div class="mb-6 bg-gradient-to-r from-red-50 to-rose-50 border-l-4 border-red-500 text-red-800 px-4 py-3 rounded-lg shadow-sm">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"></path>
                        </svg>
                        {{ session('error') }}
                    </div>
                </div>
            @endif

            <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
                <div class="p-4 sm:p-6 border-b border-gray-200 bg-gradient-to-r from-indigo-50 to-white">
                    <h3 class="text-lg font-bold text-gray-900">📋 All Employee Loans</h3>
                    <p class="text-sm text-gray-600 mt-1">View and manage all employee loan records</p>
                </div>
                
                <!-- Mobile Cards View -->
                <div class="block lg:hidden">
                    @forelse($loans as $loan)
                        <div class="border-b border-gray-200 p-4 hover:bg-indigo-50/30 transition-colors">
                            <div class="flex items-start justify-between mb-3">
                                <div class="flex-1">
                                    <h4 class="font-semibold text-gray-900">{{ $loan->user->name }}</h4>
                                    <p class="text-xs text-gray-500">{{ $loan->user->email }}</p>
                                    <p class="text-xs text-gray-400 mt-1">Started: {{ $loan->start_deduction_date->format('M d, Y') }}</p>
                                </div>
                                <span class="px-2 py-1 text-xs rounded-full font-medium
                                    {{ $loan->status === 'completed' ? 'bg-green-100 text-green-800' : 
                                       ($loan->status === 'active' ? 'bg-blue-100 text-blue-800' : 'bg-gray-100 text-gray-800') }}">
                                    {{ ucfirst($loan->status) }}
                                </span>
                            </div>

                            <div class="grid grid-cols-2 gap-3 mb-3">
                                <div class="bg-indigo-50 rounded-lg p-3">
                                    <p class="text-xs text-indigo-600 font-medium">Total Amount</p>
                                    <p class="text-lg font-bold text-indigo-900">Rs. {{ number_format($loan->total_amount, 0) }}</p>
                                </div>
                                <div class="bg-orange-50 rounded-lg p-3">
                                    <p class="text-xs text-orange-600 font-medium">Remaining</p>
                                    <p class="text-lg font-bold text-orange-900">Rs. {{ number_format($loan->remaining_amount, 0) }}</p>
                                </div>
                            </div>

                            <div class="mb-3">
                                <div class="flex justify-between text-xs text-gray-600 mb-1">
                                    <span>{{ $loan->paid_installments }}/{{ $loan->total_installments }} installments</span>
                                    <span>{{ round(($loan->paid_installments / $loan->total_installments) * 100) }}%</span>
                                </div>
                                <div class="w-full bg-gray-200 rounded-full h-2.5">
                                    <div class="bg-gradient-to-r from-blue-500 to-indigo-600 h-2.5 rounded-full transition-all duration-500" 
                                         style="width: {{ ($loan->paid_installments / $loan->total_installments) * 100 }}%"></div>
                                </div>
                            </div>

                            <div class="space-y-2 text-sm mb-3">
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Monthly Installment:</span>
                                    <span class="font-medium">Rs. {{ number_format($loan->monthly_installment, 0) }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Paid Amount:</span>
                                    <span class="font-medium text-green-600">Rs. {{ number_format($loan->paid_amount, 0) }}</span>
                                </div>
                            </div>

                            @if($loan->purpose)
                                <div class="mb-3 p-2 bg-gray-50 rounded text-xs text-gray-600">
                                    <strong>Purpose:</strong> {{ $loan->purpose }}
                                </div>
                            @endif

                            @if($loan->status === 'active')
                                <form method="POST" action="{{ route('admin.loans.cancel', $loan->id) }}" 
                                      onsubmit="return confirm('Are you sure you want to cancel this loan?')">
                                    @csrf
                                    <button type="submit" class="w-full text-sm px-3 py-2 bg-red-50 text-red-700 rounded-lg hover:bg-red-100 transition-colors">
                                        ❌ Cancel Loan
                                    </button>
                                </form>
                            @endif
                        </div>
                    @empty
                        <div class="p-12 text-center">
                            <svg class="w-16 h-16 mx-auto text-gray-300 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path>
                            </svg>
                            <p class="text-gray-500">No loans found</p>
                        </div>
                    @endforelse
                </div>

                <!-- Desktop Table View -->
                <div class="hidden lg:block overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Employee</th>
                                <th class="px-4 py-3 text-right text-xs font-semibold text-gray-600 uppercase tracking-wider">Total Amount</th>
                                <th class="px-4 py-3 text-right text-xs font-semibold text-gray-600 uppercase tracking-wider">Monthly</th>
                                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Progress</th>
                                <th class="px-4 py-3 text-right text-xs font-semibold text-gray-600 uppercase tracking-wider">Paid</th>
                                <th class="px-4 py-3 text-right text-xs font-semibold text-gray-600 uppercase tracking-wider">Remaining</th>
                                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Start Date</th>
                                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Status</th>
                                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @forelse($loans as $loan)
                                <tr class="hover:bg-indigo-50/30 transition-colors">
                                    <td class="px-4 py-4">
                                        <div class="font-medium text-gray-900">{{ $loan->user->name }}</div>
                                        <div class="text-sm text-gray-500">{{ $loan->user->email }}</div>
                                    </td>
                                    <td class="px-4 py-4 text-right font-bold text-indigo-600">Rs. {{ number_format($loan->total_amount, 0) }}</td>
                                    <td class="px-4 py-4 text-right font-medium">Rs. {{ number_format($loan->monthly_installment, 0) }}</td>
                                    <td class="px-4 py-4" style="min-width: 200px;">
                                        <div class="text-sm mb-1">
                                            <span class="font-semibold">{{ $loan->paid_installments }}</span> / {{ $loan->total_installments }} installments
                                        </div>
                                        <div class="w-full bg-gray-200 rounded-full h-2.5">
                                            <div class="bg-gradient-to-r from-blue-500 to-indigo-600 h-2.5 rounded-full transition-all duration-500" 
                                                 style="width: {{ ($loan->paid_installments / $loan->total_installments) * 100 }}%"></div>
                                        </div>
                                        <div class="text-xs text-gray-500 mt-1">{{ round(($loan->paid_installments / $loan->total_installments) * 100) }}% complete</div>
                                    </td>
                                    <td class="px-4 py-4 text-right text-green-600 font-medium">Rs. {{ number_format($loan->paid_amount, 0) }}</td>
                                    <td class="px-4 py-4 text-right font-bold text-orange-600">Rs. {{ number_format($loan->remaining_amount, 0) }}</td>
                                    <td class="px-4 py-4 text-sm">{{ $loan->start_deduction_date->format('M d, Y') }}</td>
                                    <td class="px-4 py-4">
                                        <span class="px-3 py-1 text-xs rounded-full font-medium
                                            {{ $loan->status === 'completed' ? 'bg-green-100 text-green-800' : 
                                               ($loan->status === 'active' ? 'bg-blue-100 text-blue-800' : 'bg-gray-100 text-gray-800') }}">
                                            {{ ucfirst($loan->status) }}
                                        </span>
                                    </td>
                                    <td class="px-4 py-4">
                                        <div class="flex flex-col gap-1">
                                            @if($loan->purpose)
                                                <button onclick="showPurpose('{{ addslashes($loan->purpose) }}')" 
                                                        class="text-blue-600 hover:text-blue-800 text-sm font-medium hover:underline text-left">
                                                    📝 Purpose
                                                </button>
                                            @endif
                                            @if($loan->status === 'active')
                                                <form method="POST" action="{{ route('admin.loans.cancel', $loan->id) }}" 
                                                      onsubmit="return confirm('Are you sure you want to cancel this loan?')">
                                                    @csrf
                                                    <button type="submit" class="text-red-600 hover:text-red-800 text-sm font-medium hover:underline">
                                                        ❌ Cancel
                                                    </button>
                                                </form>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="9" class="px-4 py-12 text-center">
                                        <svg class="w-16 h-16 mx-auto text-gray-300 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path>
                                        </svg>
                                        <p class="text-gray-500 text-lg">No loans found</p>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <div class="p-4 border-t border-gray-200">
                    {{ $loans->links() }}
                </div>
            </div>
        </div>
    </div>

    <script>
        function showPurpose(purpose) {
            alert('Purpose: ' + purpose);
        }
    </script>

    <style>
        @keyframes fade-in {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .animate-fade-in {
            animation: fade-in 0.3s ease-out;
        }
    </style>
</x-app-layout>
