<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Payroll Details') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-4xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <div class="flex justify-between items-start mb-6">
                        <div>
                            <h3 class="text-2xl font-bold">{{ $payroll->user->name }}</h3>
                            <p class="text-gray-600">{{ \Carbon\Carbon::parse($payroll->month)->format('F Y') }}</p>
                        </div>
                        <span class="px-3 py-1 rounded-full text-sm
                            {{ $payroll->status === 'paid' ? 'bg-green-100 text-green-800' : 
                               ($payroll->status === 'processed' ? 'bg-blue-100 text-blue-800' : 'bg-yellow-100 text-yellow-800') }}">
                            {{ ucfirst($payroll->status) }}
                        </span>
                    </div>

                    <div class="grid grid-cols-2 gap-6 mb-6">
                        <div class="bg-gray-50 p-4 rounded">
                            <h4 class="font-semibold mb-3">Employee Information</h4>
                            <div class="space-y-2 text-sm">
                                <div><strong>Email:</strong> {{ $payroll->user->email }}</div>
                                <div><strong>EPF Number:</strong> {{ $payroll->user->epf_number ?? 'N/A' }}</div>
                                <div><strong>ETF Number:</strong> {{ $payroll->user->etf_number ?? 'N/A' }}</div>
                            </div>
                        </div>

                        <div class="bg-gray-50 p-4 rounded">
                            <h4 class="font-semibold mb-3">Bank Information</h4>
                            <div class="space-y-2 text-sm">
                                <div><strong>Bank:</strong> {{ $payroll->user->bank_name ?? 'N/A' }}</div>
                                <div><strong>Account:</strong> {{ $payroll->user->bank_account_number ?? 'N/A' }}</div>
                                <div><strong>Branch:</strong> {{ $payroll->user->bank_branch ?? 'N/A' }}</div>
                            </div>
                        </div>
                    </div>

                    <div class="border-t pt-6">
                        <h4 class="font-semibold mb-4">Salary Breakdown</h4>
                        
                        <table class="w-full">
                            <tr class="border-b">
                                <td class="py-2">Basic Salary</td>
                                <td class="py-2 text-right">Rs. {{ number_format($payroll->basic_salary, 2) }}</td>
                            </tr>
                            <tr class="border-b">
                                <td class="py-2">Commission</td>
                                <td class="py-2 text-right">Rs. {{ number_format($payroll->total_commission, 2) }}</td>
                            </tr>
                            <tr class="border-b bg-gray-50 font-semibold">
                                <td class="py-2">Gross Salary</td>
                                <td class="py-2 text-right">Rs. {{ number_format($payroll->gross_salary, 2) }}</td>
                            </tr>
                            <tr class="border-b">
                                <td class="py-2 text-red-600">EPF (Employee 8%)</td>
                                <td class="py-2 text-right text-red-600">- Rs. {{ number_format($payroll->epf_employee, 2) }}</td>
                            </tr>
                            <tr class="border-b">
                                <td class="py-2 text-red-600">ETF (Employee 3%)</td>
                                <td class="py-2 text-right text-red-600">- Rs. {{ number_format($payroll->etf_employee, 2) }}</td>
                            </tr>
                            @if($payroll->salary_advance_deduction > 0)
                            <tr class="border-b">
                                <td class="py-2 text-red-600">Salary Advance Deduction</td>
                                <td class="py-2 text-right text-red-600">- Rs. {{ number_format($payroll->salary_advance_deduction, 2) }}</td>
                            </tr>
                            @endif
                            @if($payroll->loan_deduction > 0)
                            <tr class="border-b">
                                <td class="py-2 text-red-600">Loan Installment</td>
                                <td class="py-2 text-right text-red-600">- Rs. {{ number_format($payroll->loan_deduction, 2) }}</td>
                            </tr>
                            @endif
                            @if($payroll->other_deductions > 0)
                            <tr class="border-b">
                                <td class="py-2 text-red-600">Other Deductions</td>
                                <td class="py-2 text-right text-red-600">- Rs. {{ number_format($payroll->other_deductions, 2) }}</td>
                            </tr>
                            @endif
                            <tr class="border-b bg-gray-50 font-semibold">
                                <td class="py-2 text-red-600">Total Deductions</td>
                                <td class="py-2 text-right text-red-600">- Rs. {{ number_format($payroll->total_deductions, 2) }}</td>
                            </tr>
                            <tr class="bg-green-50 font-bold text-lg">
                                <td class="py-3 text-green-700">Net Salary</td>
                                <td class="py-3 text-right text-green-700">Rs. {{ number_format($payroll->net_salary, 2) }}</td>
                            </tr>
                        </table>
                    </div>

                    <div class="border-t mt-6 pt-6">
                        <h4 class="font-semibold mb-4">Employer Contributions</h4>
                        <table class="w-full">
                            <tr class="border-b">
                                <td class="py-2">EPF (Employer 12%)</td>
                                <td class="py-2 text-right">Rs. {{ number_format($payroll->epf_employer, 2) }}</td>
                            </tr>
                            <tr class="border-b">
                                <td class="py-2">ETF (Employer 3%)</td>
                                <td class="py-2 text-right">Rs. {{ number_format($payroll->etf_employer, 2) }}</td>
                            </tr>
                            <tr class="bg-gray-50 font-semibold">
                                <td class="py-2">Total Employer Contribution</td>
                                <td class="py-2 text-right">Rs. {{ number_format($payroll->epf_employer + $payroll->etf_employer, 2) }}</td>
                            </tr>
                        </table>
                    </div>

                    @if($payroll->notes)
                    <div class="border-t mt-6 pt-6">
                        <h4 class="font-semibold mb-2">Notes</h4>
                        <p class="text-gray-700">{{ $payroll->notes }}</p>
                    </div>
                    @endif

                    <div class="mt-6 flex gap-3">
                        <a href="{{ route('admin.payroll.index') }}" 
                           class="bg-gray-600 hover:bg-gray-700 text-white px-6 py-2 rounded-md">
                            Back to Payroll
                        </a>
                        @if($payroll->status !== 'paid')
                        <form method="POST" action="{{ route('admin.payroll.mark-paid', $payroll->id) }}">
                            @csrf
                            <button type="submit" 
                                    class="bg-green-600 hover:bg-green-700 text-white px-6 py-2 rounded-md">
                                Mark as Paid
                            </button>
                        </form>
                        @endif
                        <button onclick="window.print()" 
                                class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-md">
                            Print
                        </button>

                        @if($payroll->status !== 'paid')
                        <form method="POST" action="{{ route('admin.payroll.recalculate', $payroll->id) }}">
                            @csrf
                            <button type="submit" 
                                    class="bg-yellow-500 hover:bg-yellow-600 text-white px-6 py-2 rounded-md"
                                    onclick="return confirm('Recalculate will update commissions and tax based on current approved records. Continue?')">
                                Recalculate
                            </button>
                        </form>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
