<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Add New Product') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <form action="{{ route('admin.products.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        
                        <!-- Section 1: Basic Details -->
                        <h3 class="text-lg font-medium text-gray-900 border-b pb-2 mb-4">1. Basic Details</h3>
                        <div class="grid grid-cols-2 gap-6 mb-6">
                            <div>
                                <x-input-label for="name" :value="__('Product Name')" />
                                <x-text-input id="name" class="block mt-1 w-full" type="text" name="name" required autofocus placeholder="e.g. Nice Biscuits" />
                            </div>
                            <div>
                                <x-input-label for="base_cost" :value="__('Base Cost (Per Unit)')" />
                                <x-text-input id="base_cost" class="block mt-1 w-full" type="number" step="0.01" name="base_cost" required placeholder="0.00" />
                            </div>
                            <div class="col-span-2">
                                <x-input-label for="image" :value="__('Product Image')" />
                                <input id="image" type="file" name="image" class="block mt-1 w-full text-sm text-gray-900 border border-gray-300 rounded-lg cursor-pointer bg-gray-50 focus:outline-none">
                            </div>
                        </div>

                        <!-- Section 2: Carton Configuration -->
                        <h3 class="text-lg font-medium text-gray-900 border-b pb-2 mb-4">2. Carton Configuration</h3>
                        <div class="grid grid-cols-3 gap-4 mb-6">
                            <div>
                                <x-input-label for="pcs_per_carton" :value="__('How many pcs in one carton?')" />
                                <x-text-input id="pcs_per_carton" class="block mt-1 w-full" type="number" name="pcs_per_carton" required placeholder="e.g. 24" />
                            </div>
                            <div>
                                <x-input-label for="carton_weight" :value="__('Weight (kg)')" />
                                <x-text-input id="carton_weight" class="block mt-1 w-full" type="number" step="0.01" name="carton_weight" required placeholder="kg" />
                            </div>
                            <div class="grid grid-cols-3 gap-2 col-span-1">
                                <div>
                                    <x-input-label for="carton_length" :value="__('L (cm)')" />
                                    <x-text-input id="carton_length" class="block mt-1 w-full" type="number" step="0.1" name="carton_length" required />
                                </div>
                                <div>
                                    <x-input-label for="carton_width" :value="__('W (cm)')" />
                                    <x-text-input id="carton_width" class="block mt-1 w-full" type="number" step="0.1" name="carton_width" required />
                                </div>
                                <div>
                                    <x-input-label for="carton_height" :value="__('H (cm)')" />
                                    <x-text-input id="carton_height" class="block mt-1 w-full" type="number" step="0.1" name="carton_height" required />
                                </div>
                            </div>
                        </div>

                        <!-- Section 3: Pricing (Per Unit) -->
                        <h3 class="text-lg font-medium text-gray-900 border-b pb-2 mb-4">3. Price Levels (Per Unit)</h3>
                        <div class="grid grid-cols-4 gap-4 mb-6">
                            <div>
                                <label class="block font-medium text-sm text-gray-700">VVIP Price</label>
                                <input type="number" step="0.01" name="price_vvip" class="block mt-1 w-full border-gray-300 rounded-md shadow-sm" required placeholder="0.00">
                            </div>
                            <div>
                                <label class="block font-medium text-sm text-gray-700">VIP Price</label>
                                <input type="number" step="0.01" name="price_vip" class="block mt-1 w-full border-gray-300 rounded-md shadow-sm" required placeholder="0.00">
                            </div>
                            <div>
                                <label class="block font-medium text-sm text-gray-700">Wholesale Price</label>
                                <input type="number" step="0.01" name="price_wholesale" class="block mt-1 w-full border-gray-300 rounded-md shadow-sm" required placeholder="0.00">
                            </div>
                            <div>
                                <label class="block font-medium text-sm text-gray-700">Retail Price</label>
                                <input type="number" step="0.01" name="price_retail" class="block mt-1 w-full border-gray-300 rounded-md shadow-sm" required placeholder="0.00">
                            </div>
                        </div>

                        <div class="flex items-center justify-end mt-4">
                            <x-primary-button class="ml-4">
                                {{ __('Save Product') }}
                            </x-primary-button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
