<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Create Sales Representative') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <form action="{{ route('admin.reps.store') }}" method="POST">
                        @csrf
                        <div class="grid grid-cols-2 gap-6">
                            <div>
                                <x-input-label for="name" :value="__('Name')" />
                                <x-text-input id="name" class="block mt-1 w-full" type="text" name="name" required />
                            </div>
                            <div>
                                <x-input-label for="email" :value="__('Email (Login ID)')" />
                                <x-text-input id="email" class="block mt-1 w-full" type="email" name="email" required />
                            </div>
                            <div>
                                <x-input-label for="password" :value="__('Password')" />
                                <x-text-input id="password" class="block mt-1 w-full" type="password" name="password" required />
                            </div>
                            <div>
                                <x-input-label for="password_confirmation" :value="__('Confirm Password')" />
                                <x-text-input id="password_confirmation" class="block mt-1 w-full" type="password" name="password_confirmation" required />
                            </div>
                            <div>
                                <x-input-label for="mobile" :value="__('Phone Number')" />
                                <x-text-input id="mobile" class="block mt-1 w-full" type="text" name="mobile" required />
                            </div>
                            <div>
                                <x-input-label for="address" :value="__('Address')" />
                                <x-text-input id="address" class="block mt-1 w-full" type="text" name="address" />
                            </div>

                             <div class="col-span-2">
                                <x-input-label for="vehicle_id" :value="__('Assign Vehicle (Optional)')" />
                                <select id="vehicle_id" name="vehicle_id" class="block mt-1 w-full border-gray-300 rounded-md shadow-sm">
                                    <option value="">None</option>
                                    @foreach($vehicles as $vehicle)
                                        <option value="{{ $vehicle->id }}">{{ $vehicle->truck_number }} ({{ $vehicle->driver_name }})</option>
                                    @endforeach
                                </select>
                            </div>
                            
                            <div class="col-span-2">
                                <h3 class="font-bold text-gray-700 mb-2">Commissions</h3>
                                <div class="grid grid-cols-3 gap-4">
                                    <div>
                                        <x-input-label for="commission_cash" :value="__('Cash (%)')" />
                                        <x-text-input id="commission_cash" class="block mt-1 w-full" type="number" step="0.01" name="commission_cash" required />
                                    </div>
                                    <div>
                                        <x-input-label for="commission_credit" :value="__('Credit (%)')" />
                                        <x-text-input id="commission_credit" class="block mt-1 w-full" type="number" step="0.01" name="commission_credit" required />
                                    </div>
                                    <div>
                                        <x-input-label for="commission_cheque" :value="__('Cheque (%)')" />
                                        <x-text-input id="commission_cheque" class="block mt-1 w-full" type="number" step="0.01" name="commission_cheque" required />
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="flex items-center justify-end mt-4">
                             <x-primary-button class="ml-4">
                                {{ __('Create Rep') }}
                            </x-primary-button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
