<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-2xl text-gray-800 dark:text-gray-200 leading-tight">
                {{ __('Sales Force') }}
            </h2>
            <a href="{{ route('admin.reps.create') }}" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded-xl shadow-lg transition flex items-center">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path></svg>
                Create Rep
            </a>
        </div>
    </x-slot>

    <div class="py-12 bg-gray-100 dark:bg-gray-900 min-h-screen">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            
            <!-- Mobile View: Cards -->
            <div class="md:hidden space-y-4 px-4 sm:px-0">
                @foreach($reps as $rep)
                <div class="bg-white dark:bg-gray-800 p-6 rounded-2xl shadow-xl border border-gray-100 dark:border-gray-700">
                    <div class="flex items-center justify-between mb-4">
                        <div class="flex items-center space-x-3">
                            <div class="h-12 w-12 rounded-full bg-gradient-to-tr from-blue-400 to-indigo-500 flex items-center justify-center text-white font-bold text-lg shadow-md">
                                {{ substr($rep->name, 0, 1) }}
                            </div>
                            <div>
                                <div class="text-lg font-bold text-gray-900 dark:text-white">{{ $rep->name }}</div>
                                <div class="text-sm text-gray-500 dark:text-gray-400">{{ $rep->mobile }}</div>
                            </div>
                        </div>
                        
                         <a href="{{ route('admin.reps.edit', $rep->id) }}" class="p-2 bg-gray-100 dark:bg-gray-700 rounded-full text-gray-600 dark:text-gray-300">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.232 5.232l3.536 3.536m-2.036-5.036a2.5 2.5 0 113.536 3.536L6.5 21.036H3v-3.572L16.732 3.732z"></path></svg>
                        </a>
                    </div>
                    
                    <div class="grid grid-cols-3 gap-2 text-center bg-gray-50 dark:bg-gray-700 p-3 rounded-xl mb-4">
                        <div>
                            <span class="block text-xs text-gray-500 dark:text-gray-400 uppercase tracking-wide">Cash</span>
                            <span class="font-bold text-indigo-600 dark:text-indigo-400">{{ $rep->commission_cash }}%</span>
                        </div>
                        <div class="border-l border-r border-gray-200 dark:border-gray-600">
                           <span class="block text-xs text-gray-500 dark:text-gray-400 uppercase tracking-wide">Credit</span>
                           <span class="font-bold text-emerald-600 dark:text-emerald-400">{{ $rep->commission_credit }}%</span>
                        </div>
                         <div>
                            <span class="block text-xs text-gray-500 dark:text-gray-400 uppercase tracking-wide">Chq</span>
                            <span class="font-bold text-amber-600 dark:text-amber-400">{{ $rep->commission_cheque }}%</span>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>

            <!-- Desktop View: Table -->
            <div class="hidden md:block bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-2xl">
                 <table class="min-w-full leading-normal">
                    <thead>
                        <tr class="bg-gray-50 dark:bg-gray-700 border-b border-gray-200 dark:border-gray-600">
                            <th class="px-5 py-3 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Name / Mobile</th>
                            <th class="px-5 py-3 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Cash Comm.</th>
                            <th class="px-5 py-3 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Credit Comm.</th>
                             <th class="px-5 py-3 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Cheque Comm.</th>
                            <th class="px-5 py-3 text-right text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200 dark:divide-gray-700">
                         @foreach($reps as $rep)
                            <tr class="hover:bg-gray-50 dark:hover:bg-gray-700 transition">
                                <td class="px-5 py-4 whitespace-nowrap">
                                    <div class="flex items-center">
                                       <div class="h-10 w-10 rounded-full bg-indigo-100 flex items-center justify-center text-indigo-600 font-bold mr-3">
                                            {{ substr($rep->name, 0, 1) }}
                                        </div>
                                        <div>
                                            <div class="text-sm font-bold text-gray-900 dark:text-white">{{ $rep->name }}</div>
                                            <div class="text-sm text-gray-500 dark:text-gray-400">{{ $rep->mobile }}</div>
                                        </div>
                                    </div>
                                </td>
                                <td class="px-5 py-4 whitespace-nowrap text-center">
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-blue-100 text-blue-800">{{ $rep->commission_cash }}%</span>
                                </td>
                                <td class="px-5 py-4 whitespace-nowrap text-center">
                                     <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800">{{ $rep->commission_credit }}%</span>
                                </td>
                                <td class="px-5 py-4 whitespace-nowrap text-center">
                                     <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-yellow-100 text-yellow-800">{{ $rep->commission_cheque }}%</span>
                                </td>
                                <td class="px-5 py-4 whitespace-nowrap text-right text-sm font-medium">
                                    <a href="{{ route('admin.reps.edit', $rep->id) }}" class="text-indigo-600 hover:text-indigo-900 dark:hover:text-indigo-400">Edit</a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                 </table>
            </div>
        </div>
    </div>
</x-app-layout>
