<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Create Salary Advance') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-3xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <form method="POST" action="{{ route('admin.salary-advances.store') }}">
                        @csrf

                        <div class="space-y-4">
                            <div>
                                <label for="user_id" class="block text-sm font-medium text-gray-700 mb-1">
                                    Employee <span class="text-red-500">*</span>
                                </label>
                                <select id="user_id" name="user_id" required
                                        class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                    <option value="">Select Employee</option>
                                    @foreach($users as $user)
                                        <option value="{{ $user->id }}" {{ old('user_id') == $user->id ? 'selected' : '' }}>
                                            {{ $user->name }} ({{ $user->email }})
                                        </option>
                                    @endforeach
                                </select>
                                @error('user_id')
                                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                @enderror
                            </div>

                            <div>
                                <label for="amount" class="block text-sm font-medium text-gray-700 mb-1">
                                    Amount (Rs.) <span class="text-red-500">*</span>
                                </label>
                                <input type="number" 
                                       id="amount" 
                                       name="amount" 
                                       step="0.01"
                                       min="0"
                                       value="{{ old('amount') }}"
                                       required
                                       class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                       placeholder="0.00">
                                @error('amount')
                                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                @enderror
                            </div>

                            <div>
                                <label for="advance_date" class="block text-sm font-medium text-gray-700 mb-1">
                                    Advance Date <span class="text-red-500">*</span>
                                </label>
                                <input type="date" 
                                       id="advance_date" 
                                       name="advance_date" 
                                       value="{{ old('advance_date', now()->format('Y-m-d')) }}"
                                       required
                                       class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                @error('advance_date')
                                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                @enderror
                            </div>

                            <div>
                                <label for="reason" class="block text-sm font-medium text-gray-700 mb-1">
                                    Reason (Optional)
                                </label>
                                <textarea id="reason" 
                                          name="reason" 
                                          rows="3"
                                          class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                          placeholder="Enter reason for salary advance">{{ old('reason') }}</textarea>
                                @error('reason')
                                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="p-4 bg-blue-50 rounded">
                                <p class="text-sm text-blue-800">
                                    <strong>Note:</strong> The salary advance will be automatically deducted from the employee's next payroll (up to 50% of gross salary per month until fully recovered).
                                </p>
                            </div>

                            <div class="flex gap-3 pt-4">
                                <button type="submit" 
                                        class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-md">
                                    Create Salary Advance
                                </button>
                                <a href="{{ route('admin.salary-advances.index') }}" 
                                   class="bg-gray-600 hover:bg-gray-700 text-white px-6 py-2 rounded-md">
                                    Cancel
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
