<x-app-layout>
    <x-slot name="header">
        <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
            <div>
                <h2 class="font-bold text-2xl text-gray-900 leading-tight">
                    💵 Salary Advances
                </h2>
                <p class="text-sm text-gray-600 mt-1">Manage employee salary advances and track deductions</p>
            </div>
            <a href="{{ route('admin.salary-advances.create') }}" 
               class="inline-flex items-center px-4 py-2 bg-gradient-to-r from-purple-600 to-purple-700 hover:from-purple-700 hover:to-purple-800 text-white text-sm font-medium rounded-lg shadow-lg transition-all duration-200 hover:shadow-xl transform hover:-translate-y-0.5">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                </svg>
                New Salary Advance
            </a>
        </div>
    </x-slot>

    <div class="py-6 sm:py-12">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            @if(session('success'))
                <div class="mb-6 bg-gradient-to-r from-green-50 to-emerald-50 border-l-4 border-green-500 text-green-800 px-4 py-3 rounded-lg shadow-sm animate-fade-in">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                        </svg>
                        {{ session('success') }}
                    </div>
                </div>
            @endif

            @if(session('error'))
                <div class="mb-6 bg-gradient-to-r from-red-50 to-rose-50 border-l-4 border-red-500 text-red-800 px-4 py-3 rounded-lg shadow-sm">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"></path>
                        </svg>
                        {{ session('error') }}
                    </div>
                </div>
            @endif

            <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
                <div class="p-4 sm:p-6 border-b border-gray-200 bg-gradient-to-r from-purple-50 to-white">
                    <h3 class="text-lg font-bold text-gray-900">📋 All Salary Advances</h3>
                    <p class="text-sm text-gray-600 mt-1">View and manage all employee salary advances</p>
                </div>
                
                <!-- Mobile Cards View -->
                <div class="block lg:hidden">
                    @forelse($advances as $advance)
                        <div class="border-b border-gray-200 p-4 hover:bg-purple-50/30 transition-colors">
                            <div class="flex items-start justify-between mb-3">
                                <div class="flex-1">
                                    <h4 class="font-semibold text-gray-900">{{ $advance->user->name }}</h4>
                                    <p class="text-xs text-gray-500">{{ $advance->user->email }}</p>
                                    <p class="text-xs text-gray-400 mt-1">{{ $advance->advance_date->format('M d, Y') }}</p>
                                </div>
                                <span class="px-2 py-1 text-xs rounded-full font-medium
                                    {{ $advance->status === 'fully_deducted' ? 'bg-green-100 text-green-800' : 
                                       ($advance->status === 'partially_deducted' ? 'bg-yellow-100 text-yellow-800' : 'bg-blue-100 text-blue-800') }}">
                                    {{ ucfirst(str_replace('_', ' ', $advance->status)) }}
                                </span>
                            </div>

                            <div class="grid grid-cols-2 gap-3 mb-3">
                                <div class="bg-purple-50 rounded-lg p-3">
                                    <p class="text-xs text-purple-600 font-medium">Amount</p>
                                    <p class="text-lg font-bold text-purple-900">Rs. {{ number_format($advance->amount, 0) }}</p>
                                </div>
                                <div class="bg-orange-50 rounded-lg p-3">
                                    <p class="text-xs text-orange-600 font-medium">Remaining</p>
                                    <p class="text-lg font-bold text-orange-900">Rs. {{ number_format($advance->remaining_amount, 0) }}</p>
                                </div>
                            </div>

                            <div class="space-y-2 text-sm mb-3">
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Deducted:</span>
                                    <span class="font-medium text-green-600">Rs. {{ number_format($advance->deducted_amount, 0) }}</span>
                                </div>
                                @if($advance->approver)
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Approved by:</span>
                                    <span class="font-medium">{{ $advance->approver->name }}</span>
                                </div>
                                @endif
                            </div>

                            @if($advance->reason)
                                <div class="mb-3 p-2 bg-gray-50 rounded text-xs text-gray-600">
                                    <strong>Reason:</strong> {{ $advance->reason }}
                                </div>
                            @endif

                            @if($advance->status === 'pending')
                                <form method="POST" action="{{ route('admin.salary-advances.destroy', $advance->id) }}" 
                                      onsubmit="return confirm('Are you sure you want to delete this salary advance?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="w-full text-sm px-3 py-2 bg-red-50 text-red-700 rounded-lg hover:bg-red-100 transition-colors">
                                        🗑️ Delete
                                    </button>
                                </form>
                            @endif
                        </div>
                    @empty
                        <div class="p-12 text-center">
                            <svg class="w-16 h-16 mx-auto text-gray-300 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <p class="text-gray-500">No salary advances found</p>
                        </div>
                    @endforelse
                </div>

                <!-- Desktop Table View -->
                <div class="hidden lg:block overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Employee</th>
                                <th class="px-4 py-3 text-right text-xs font-semibold text-gray-600 uppercase tracking-wider">Amount</th>
                                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Date</th>
                                <th class="px-4 py-3 text-right text-xs font-semibold text-gray-600 uppercase tracking-wider">Deducted</th>
                                <th class="px-4 py-3 text-right text-xs font-semibold text-gray-600 uppercase tracking-wider">Remaining</th>
                                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Status</th>
                                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Approved By</th>
                                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @forelse($advances as $advance)
                                <tr class="hover:bg-purple-50/30 transition-colors">
                                    <td class="px-4 py-4">
                                        <div class="font-medium text-gray-900">{{ $advance->user->name }}</div>
                                        <div class="text-sm text-gray-500">{{ $advance->user->email }}</div>
                                    </td>
                                    <td class="px-4 py-4 text-right font-bold text-purple-600">Rs. {{ number_format($advance->amount, 0) }}</td>
                                    <td class="px-4 py-4">{{ $advance->advance_date->format('M d, Y') }}</td>
                                    <td class="px-4 py-4 text-right text-green-600 font-medium">Rs. {{ number_format($advance->deducted_amount, 0) }}</td>
                                    <td class="px-4 py-4 text-right font-bold text-orange-600">Rs. {{ number_format($advance->remaining_amount, 0) }}</td>
                                    <td class="px-4 py-4">
                                        <span class="px-3 py-1 text-xs rounded-full font-medium
                                            {{ $advance->status === 'fully_deducted' ? 'bg-green-100 text-green-800' : 
                                               ($advance->status === 'partially_deducted' ? 'bg-yellow-100 text-yellow-800' : 'bg-blue-100 text-blue-800') }}">
                                            {{ ucfirst(str_replace('_', ' ', $advance->status)) }}
                                        </span>
                                    </td>
                                    <td class="px-4 py-4 text-sm text-gray-600">
                                        {{ $advance->approver->name ?? 'N/A' }}
                                    </td>
                                    <td class="px-4 py-4">
                                        <div class="flex gap-2">
                                            @if($advance->reason)
                                                <button onclick="showReason('{{ addslashes($advance->reason) }}')" 
                                                        class="text-blue-600 hover:text-blue-800 text-sm font-medium hover:underline">
                                                    📝 Reason
                                                </button>
                                            @endif
                                            @if($advance->status === 'pending')
                                                <form method="POST" action="{{ route('admin.salary-advances.destroy', $advance->id) }}" 
                                                      onsubmit="return confirm('Are you sure you want to delete this salary advance?')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="text-red-600 hover:text-red-800 text-sm font-medium hover:underline">
                                                        🗑️ Delete
                                                    </button>
                                                </form>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="8" class="px-4 py-12 text-center">
                                        <svg class="w-16 h-16 mx-auto text-gray-300 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                        </svg>
                                        <p class="text-gray-500 text-lg">No salary advances found</p>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <div class="p-4 border-t border-gray-200">
                    {{ $advances->links() }}
                </div>
            </div>
        </div>
    </div>

    <script>
        function showReason(reason) {
            alert('Reason: ' + reason);
        }
    </script>

    <style>
        @keyframes fade-in {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .animate-fade-in {
            animation: fade-in 0.3s ease-out;
        }
    </style>
</x-app-layout>
