<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Load Truck for Delivery') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <form action="{{ route('admin.stock-transfer.store') }}" method="POST">
                        @csrf
                        <div class="mb-6">
                            <x-input-label for="vehicle_id" :value="__('Select Truck to Load')" />
                            <select id="vehicle_id" name="vehicle_id" class="block mt-1 w-full border-gray-300 rounded-md shadow-sm">
                                @foreach($vehicles as $vehicle)
                                    <option value="{{ $vehicle->id }}">{{ $vehicle->truck_number }} ({{ $vehicle->driver_name }})</option>
                                @endforeach
                            </select>
                        </div>
                        
                        <div class="mb-6">
                            <x-input-label for="sales_rep_id" :value="__('Assign Sales Representative')" />
                            <select id="sales_rep_id" name="sales_rep_id" class="block mt-1 w-full border-gray-300 rounded-md shadow-sm">
                                <option value="">Select Sales Rep...</option>
                                @foreach($salesReps as $rep)
                                    <option value="{{ $rep->id }}">{{ $rep->name }} (@if($rep->vehicle) Current: {{ $rep->vehicle->truck_number }} @else No Vehicle @endif)</option>
                                @endforeach
                            </select>
                        </div>

                        <h3 class="text-lg font-bold mb-4">Stock to Load</h3>
                        <div id="items-container">
                             <div class="grid grid-cols-3 gap-4 mb-2 item-row">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Product</label>
                                    <select name="items[0][product_id]" class="block mt-1 w-full border-gray-300 rounded-md shadow-sm product-select" onchange="updatePackSizes(this)">
                                        <option value="">Select Product...</option>
                                        @foreach($products as $product)
                                            <option value="{{ $product->id }}" data-packs="{{ json_encode($product->packSizes) }}">{{ $product->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Pack Size</label>
                                    <select name="items[0][product_pack_size_id]" class="block mt-1 w-full border-gray-300 rounded-md shadow-sm pack-select">
                                        <option value="">Select Pack Size...</option>
                                    </select>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Quantity (Packs)</label>
                                    <input type="number" name="items[0][quantity]" class="block mt-1 w-full border-gray-300 rounded-md shadow-sm" placeholder="Qty">
                                </div>
                            </div>
                        </div>
                        
                         <button type="button" onclick="addItemRow()" class="mt-2 text-sm text-blue-600 hover:text-blue-900">+ Add Another Item</button>

                        <div class="flex items-center justify-end mt-4">
                            <x-primary-button class="ml-4">
                                {{ __('Load Truck') }}
                            </x-primary-button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
     <script>
        let itemCount = 1;

        function updatePackSizes(selectElement) {
            const row = selectElement.closest('.item-row');
            const packSelect = row.querySelector('.pack-select');
            const selectedOption = selectElement.options[selectElement.selectedIndex];
            // Safe JSON parse in case of empty data
            let packs = [];
            try {
                packs = JSON.parse(selectedOption.getAttribute('data-packs') || '[]');
            } catch (e) { console.error('Error parsing packs', e); }

            packSelect.innerHTML = '<option value="">Select Pack Size...</option>';
            packs.forEach(pack => {
                const option = document.createElement('option');
                option.value = pack.id;
                option.text = pack.size_name + ' (x' + pack.quantity + ')';
                packSelect.appendChild(option);
            });
        }

        function addItemRow() {
            const container = document.getElementById('items-container');
            const firstRow = container.querySelector('.item-row');
            const newRow = firstRow.cloneNode(true);
            
            newRow.querySelectorAll('input').forEach(input => input.value = '');
            newRow.querySelectorAll('select').forEach(select => select.selectedIndex = 0);
            
            newRow.querySelectorAll('[name]').forEach(el => {
                el.name = el.name.replace(/\[\d+\]/, '[' + itemCount + ']');
            });

            container.appendChild(newRow);
            itemCount++;
        }
    </script>
</x-app-layout>
