<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Add New Truck') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <form action="{{ route('admin.vehicles.store') }}" method="POST">
                        @csrf
                        <div class="grid grid-cols-2 gap-6">
                            <div>
                                <x-input-label for="truck_number" :value="__('Truck Number (Plate)')" />
                                <x-text-input id="truck_number" class="block mt-1 w-full" type="text" name="truck_number" required placeholder="WP-XX-0000" />
                            </div>
                            <div>
                                <x-input-label for="driver_name" :value="__('Driver Name')" />
                                <x-text-input id="driver_name" class="block mt-1 w-full" type="text" name="driver_name" required />
                            </div>
                        </div>

                        <div class="flex items-center justify-end mt-4">
                            <x-primary-button class="ml-4">
                                {{ __('Add Truck') }}
                            </x-primary-button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
