<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Dashboard') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-6">
            
            @if(auth()->user()->isSalesRep())
                <!-- Stats Cards -->
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg p-6 border-l-4 border-red-500">
                        <div class="text-gray-500 text-sm font-medium">My Total Outstanding (Due)</div>
                        <div class="text-3xl font-bold text-gray-800 mt-2">Rs. {{ number_format($mySalesOutstanding, 2) }}</div>
                        <div class="text-xs text-red-500 mt-1">From my sales</div>
                    </div>
                    
                    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg p-6 border-l-4 border-green-500">
                        <div class="text-gray-500 text-sm font-medium">Today's Sales</div>
                        <div class="text-3xl font-bold text-gray-800 mt-2">Rs. {{ number_format($todaySales, 2) }}</div>
                    </div>

                    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg p-6 border-l-4 border-blue-500">
                        <div class="text-gray-500 text-sm font-medium">Quick Actions</div>
                        <div class="mt-4 flex flex-col space-y-2">
                             <a href="{{ route('sales.billing') }}" class="text-center w-full bg-blue-600 text-white rounded py-2 text-sm hover:bg-blue-700">Go to Billing</a>
                             <a href="{{ route('sales.customers.index') }}" class="text-center w-full bg-gray-100 text-gray-700 rounded py-2 text-sm hover:bg-gray-200">My Customers</a>
                        </div>
                    </div>
                </div>

                <!-- Charts -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Collection Mixed Chart -->
                    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg p-6">
                        <h3 class="text-lg font-bold text-gray-800 mb-4">My Collections (Cash vs Cheque)</h3>
                         <div class="w-full h-64 flex justify-center">
                            <canvas id="collectionChart"></canvas>
                        </div>
                    </div>
                    
                    <!-- Placeholder/Future Chart -->
                     <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg p-6 flex flex-col justify-center items-center text-gray-400">
                        <svg class="w-16 h-16 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path></svg>
                        <span>Performance History (Coming Soon)</span>
                    </div>
                </div>

                <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
                <script>
                    document.addEventListener('DOMContentLoaded', function() {
                        const ctx = document.getElementById('collectionChart').getContext('2d');
                        new Chart(ctx, {
                            type: 'doughnut',
                            data: {
                                labels: ['Cash Collected', 'Cheques Collected'],
                                datasets: [{
                                    data: [{{ $cashCollected ?? 0 }}, {{ $chequeCollected ?? 0 }}],
                                    backgroundColor: ['#10b981', '#3b82f6'],
                                    hoverOffset: 4
                                }]
                            },
                            options: {
                                responsive: true,
                                plugins: {
                                    legend: { position: 'bottom' }
                                }
                            }
                        });
                    });
                </script>
            @else
                <!-- Generic User Dashboard -->
                <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                    <div class="p-6 text-gray-900 dark:text-gray-100">
                        {{ __("You're logged in!") }}
                    </div>
                </div>
            @endif
        </div>
    </div>
</x-app-layout>
