<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ config('app.name', 'CHOX') }}</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Dark Mode Script (must be before body to prevent flash) -->
        <script>
            // Check for saved theme preference or default to light mode
            if (localStorage.getItem('theme') === 'dark' || (!localStorage.getItem('theme') && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
                document.documentElement.classList.add('dark');
            } else {
                document.documentElement.classList.remove('dark');
            }
        </script>

        <!-- Scripts -->
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    </head>
    <body class="font-sans antialiased">
        <div class="min-h-screen bg-gray-100 dark:bg-gray-900 transition-colors duration-200">
            @include('layouts.navigation')

            <!-- Page Content -->
            <!-- Add md:pl-64 to push content right when sidebar is fixed -->
            <main class="md:pl-64 transition-all duration-200 ease-in-out">
                <!-- Page Heading -->
                @isset($header)
                    <header class="bg-white dark:bg-gray-800 shadow transition-colors duration-200">
                        <div class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8">
                            {{ $header }}
                        </div>
                    </header>
                @endisset

                {{ $slot }}
            </main>
        </div>

        <!-- Dark Mode Toggle Script -->
        <script>
            function toggleDarkMode() {
                const html = document.documentElement;
                const isDark = html.classList.contains('dark');
                
                if (isDark) {
                    html.classList.remove('dark');
                    localStorage.setItem('theme', 'light');
                } else {
                    html.classList.add('dark');
                    localStorage.setItem('theme', 'dark');
                }
                
                // Update toggle button icons
                updateDarkModeIcons();
            }

            function updateDarkModeIcons() {
                const isDark = document.documentElement.classList.contains('dark');
                const sunIcons = document.querySelectorAll('.sun-icon');
                const moonIcons = document.querySelectorAll('.moon-icon');
                
                sunIcons.forEach(icon => {
                    icon.style.display = isDark ? 'none' : 'block';
                });
                
                moonIcons.forEach(icon => {
                    icon.style.display = isDark ? 'block' : 'none';
                });
            }

            // Update icons on page load
            document.addEventListener('DOMContentLoaded', updateDarkModeIcons);
        </script>
    </body>
</html>
