<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Invoice {{ $sale->invoice_number }}</title>
    <style>
        body { font-family: sans-serif; }
        .header { text-align: center; margin-bottom: 20px; }
        .invoice-details { margin-bottom: 20px; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        .totals { text-align: right; }
    </style>
</head>
<body>
    <div class="header">
        <h1>{{ config('app.name') }}</h1>
        <p>No: 19/2nd Floor Hanwella<br>
           ☎ 0771168439, 0771168439<br>
           Email: admin@chox.lk | Website: chox.lk
        </p>
        <h2 style="margin-top: 10px; border-bottom: 1px solid #ccc; padding-bottom: 5px;">INVOICE</h2>
    </div>

    <div class="invoice-details">
        <strong>Invoice No:</strong> {{ $sale->invoice_number }}<br>
        <strong>Date:</strong> {{ $sale->created_at->format('Y-m-d H:i') }}<br>
        <strong>Customer:</strong> {{ $sale->customer->name }} ({{ $sale->customer->mobile }})<br>
        <strong>Rep:</strong> {{ $sale->salesRep->name }}<br>
    </div>

    <table>
        <thead>
            <tr>
                <th>Product</th>
                <th>Pack</th>
                <th>Price Level</th>
                <th>Qty</th>
                <th>Unit Price</th>
                <th>Total</th>
            </tr>
        </thead>
        <tbody>
            @foreach($sale->items as $item)
                <tr>
                    <td>{{ $item->product->name }}</td>
                    <td>{{ $item->packSize->size_name }}</td>
                    <td>{{ $item->price_level_applied }}</td>
                    <td>{{ $item->quantity }}</td>
                    <td>{{ number_format($item->unit_price, 2) }}</td>
                    <td>{{ number_format($item->total_price, 2) }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div class="totals">
        <p><strong>Sub Total:</strong> {{ number_format($sale->sub_total, 2) }}</p>
        <p><strong>Net Total:</strong> {{ number_format($sale->net_total, 2) }}</p>
        
        @php
            // Calculate balances
            // Since this invoice is already created, the customer's total balance includes this invoice.
            // We want to show what was due BEFORE this invoice, and the NEW total.
             $currentTotalDue = $sale->customer->sales->sum('balance_due');
             $thisInvoiceDue = $sale->balance_due;
             $previousDue = $currentTotalDue - $thisInvoiceDue;
        @endphp

        <p style="margin-top: 10px; border-top: 1px dashed #ccc; padding-top: 5px;"><strong>Previous Balance:</strong> {{ number_format($previousDue, 2) }}</p>
        <p style="font-size: 1.1em; color: #d32f2f;"><strong>New Total Balance:</strong> {{ number_format($currentTotalDue, 2) }}</p>
    </div>
    
    <div style="margin-top: 50px; text-align: center; font-size: 0.8em;">
        <p>Thank you for your business!</p>
    </div>
</body>
</html>
