<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Payment Receipt</title>
    <style>
        body { font-family: sans-serif; font-size: 12px; }
        .header { text-align: center; margin-bottom: 20px; border-bottom: 1px solid #ddd; padding-bottom: 10px; }
        .header h1 { margin: 0; font-size: 18px; text-transform: uppercase; }
        .info-table { width: 100%; margin-bottom: 20px; }
        .info-table td { vertical-align: top; }
        .payment-box { background: #f9f9f9; padding: 10px; border: 1px solid #ddd; margin-bottom: 20px; }
        .total-paid { font-size: 14px; font-weight: bold; }
        .alloc-table, .unpaid-table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        .alloc-table th, .alloc-table td, .unpaid-table td { border-bottom: 1px solid #eee; padding: 5px; text-align: left; }
        .alloc-table th { color: #666; font-size: 10px; text-transform: uppercase; }
        .text-right { text-align: right; }
        .footer { text-align: center; color: #888; font-size: 10px; margin-top: 30px; }
        .status-badge { padding: 2px 5px; border-radius: 3px; font-size: 10px; }
        .cleared { background: #d1fae5; color: #065f46; }
        .pending { background: #fef3c7; color: #92400e; }
        .returned { background: #fee2e2; color: #b91c1c; }
    </style>
</head>
<body>
    <div class="header">
        <h1>{{ config('app.name', 'LANKA ENTERPRISES') }}</h1>
        <div style="font-size: 10px; margin-top: 5px;">
            No: 19/2nd Floor Hanwella<br>
            ☎ 0771168439, 0771168439<br>
            Email: admin@chox.lk | Website: chox.lk
        </div>
        <p style="font-weight: bold; border-top: 1px solid #ddd; border-bottom: 1px solid #ddd; padding: 5px 0; display: inline-block; margin-top: 10px;">OFFICIAL RECEIPT</p>
        <p style="font-size: 10px; color: #666; margin-top: 5px;">
            Receipt No: {{ $payments->first()->receipt_number ?? 'N/A' }} <br>
            {{ now()->format('Y-m-d h:i A') }}
        </p>
    </div>

    <table class="info-table">
        <tr>
            <td>
                <strong>Collected By:</strong><br>
                {{ $collector->name }}
            </td>
            <td class="text-right">
                <strong>Customer:</strong><br>
                {{ $customer->name }}<br>
                {{ $customer->address }}<br>
                {{ $customer->mobile }}
            </td>
        </tr>
    </table>

    <div class="payment-box">
        <div style="margin-bottom: 5px;">
            <span class="total-paid">Total Paid: LKR {{ number_format($totalPaid, 2) }}</span>
        </div>
        @foreach($payments as $payment)
            <div style="font-size: 11px; color: #555; margin-top: 5px; border-top: 1px dashed #ccc; padding-top: 5px;">
                Method: {{ $payment->method }} | {{ $payment->created_at->format('Y-m-d H:i') }}
                @if($payment->method == 'Cheque')
                    <br>
                    Bank: {{ $payment->bank_name }} | No: {{ $payment->cheque_number }} | Date: {{ $payment->cheque_date }}
                @endif
            </div>
        @endforeach
    </div>

    <h3>Payment Allocation (FIFO)</h3>
    <table class="alloc-table">
        <thead>
            <tr>
                <th>Invoice</th>
                <th class="text-right">Allocated Amount</th>
                <th class="text-right">Balance Due</th>
            </tr>
        </thead>
        <tbody>
            @foreach($allocations as $alloc)
                <tr>
                    <td>{{ $alloc['invoice'] }}</td>
                    <td class="text-right">LKR {{ number_format($alloc['amount'], 2) }}</td>
                    <td class="text-right">{{ number_format($alloc['sale_balance_after'], 2) }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    @if($otherUnpaid && $otherUnpaid->count() > 0)
        <h3>Other Unpaid Invoices</h3>
        <table class="unpaid-table">
            <tbody>
                @foreach($otherUnpaid as $inv)
                    <tr>
                        <td style="color: #666;">{{ $inv->invoice_number }} ({{ $inv->created_at->format('Y-m-d') }})</td>
                        <td class="text-right" style="color: #d32f2f;">LKR {{ number_format($inv->balance_due, 2) }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endif

    <div style="border-top: 2px solid #333; padding-top: 10px; margin-top: 10px;">
        <table width="100%">
            <tr>
                <td><strong>Total Allocated:</strong></td>
                <td class="text-right">LKR {{ number_format($totalPaid, 2) }}</td>
            </tr>
            <tr>
                <td><strong>Total Outstanding Balance:</strong></td>
                <td class="text-right" style="color: #d32f2f; font-weight: bold;">LKR {{ number_format($customer->current_outstanding, 2) }}</td>
            </tr>
        </table>
    </div>

    <div class="footer">
        <p>Thank you for your business!</p>
        <p>Generated by {{ config('app.name') }} System</p>
    </div>
</body>
</html>
