<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Payment Receipt - {{ config('app.name') }}</title>
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />
    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="font-sans text-gray-900 antialiased bg-gray-100">
    <div class="bg-white shadow">
        <div class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8 flex justify-between items-center print:hidden">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Payment Receipt') }}
            </h2>
            <div class="flex space-x-2">
                <a href="{{ url()->current() }}?download=pdf" class="bg-indigo-600 text-white px-4 py-2 rounded shadow hover:bg-indigo-700">
                    Download PDF
                </a>
                <button onclick="window.print()" class="bg-blue-600 text-white px-4 py-2 rounded shadow hover:bg-blue-700">
                    Print Receipt
                </button>
            </div>
        </div>
    </div>

    <div class="py-12 print:py-0">
        <div class="max-w-xl mx-auto sm:px-6 lg:px-8 print:w-full print:max-w-none">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg print:shadow-none border print:border-0 p-6">
                
                <!-- Business Header -->
                <div class="text-center mb-6 border-b pb-4">
                    <h1 class="text-2xl font-bold uppercase">{{ config('app.name', 'LANKA ENTERPRISES') }}</h1>
                    <div class="text-xs text-gray-600 mt-1 mb-2">
                        No: 469, Dangalla, Pepiliyawala, Pugoda.<br>
                        ☎ 0773431790, 0774 557943<br>
                        Email: salis@lankaenterprises.lk | Website: lankaenterprises.lk
                    </div>
                    <p class="text-sm font-bold text-gray-800 border-t border-b py-1 inline-block px-4">OFFICIAL RECEIPT</p>
                    <p class="text-xs text-gray-500 mt-1">
                         Receipt No: {{ $payments->first()->receipt_number ?? 'N/A' }} <br>
                         {{ now()->format('Y-m-d h:i A') }}
                    </p>
                </div>

                <!-- Rep & Customer Info -->
                <div class="mb-6 grid grid-cols-2 gap-4 text-sm">
                    <div>
                        <span class="block text-gray-500 text-xs uppercase">Collected By</span>
                        <span class="font-bold">{{ $collector->name }}</span>
                    </div>
                    <div class="text-right">
                        <span class="block text-gray-500 text-xs uppercase">Customer</span>
                        <span class="font-bold">{{ $customer->name }}</span>
                        <div class="text-xs">{{ $customer->address }}</div>
                        <div class="text-xs">{{ $customer->mobile }}</div>
                    </div>
                </div>

                <!-- Payment Details -->
                <div class="mb-6 bg-gray-50 p-4 rounded border print:border-gray-300">
                    <div class="flex justify-between items-center mb-2">
                        <span class="text-gray-600 font-medium">Total Paid</span>
                        <span class="text-xl font-bold text-gray-900">LKR {{ number_format($totalPaid, 2) }}</span>
                    </div>
                    
                    @foreach($payments as $payment)
                        <div class="text-xs text-gray-500 mt-1 border-t pt-1 flex justify-between">
                            <span>Method: {{ $payment->method }}</span>
                            <span>{{ $payment->created_at->format('Y-m-d H:i') }}</span>
                        </div>
                        @if($payment->method == 'Cheque')
                            <div class="text-xs text-gray-500 pl-2">
                                Bank: {{ $payment->bank_name }} | No: {{ $payment->cheque_number }} <br>
                                Date: {{ $payment->cheque_date ? \Carbon\Carbon::parse($payment->cheque_date)->format('Y-m-d') : '-' }}
                            </div>
                        @endif
                    @endforeach
                </div>

                <!-- Allocation Details -->
                <div class="mb-6">
                    <h3 class="text-xs font-bold uppercase text-gray-500 mb-2 border-b pb-1">Payment Allocation (FIFO)</h3>
                    <table class="w-full text-sm">
                        <thead>
                            <tr class="text-left text-xs text-gray-500">
                                <th class="pb-2">Invoice</th>
                                <th class="pb-2 text-right">Allocated</th>
                                <th class="pb-2 text-right">Balance Due</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($allocations as $alloc)
                                <tr>
                                    <td class="py-1">{{ $alloc['invoice'] }}</td>
                                    <td class="py-1 text-right font-medium">LKR {{ number_format($alloc['amount'], 2) }}</td>
                                    <td class="py-1 text-right text-gray-500">{{ number_format($alloc['sale_balance_after'], 2) }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Other Unpaid Invoices -->
                @if($otherUnpaid && $otherUnpaid->count() > 0)
                <div class="mb-6">
                    <h3 class="text-xs font-bold uppercase text-gray-500 mb-2 border-b pb-1">Other Unpaid Invoices</h3>
                    <table class="w-full text-sm">
                        <tbody>
                            @foreach($otherUnpaid as $inv)
                                <tr>
                                    <td class="py-1 text-gray-500">{{ $inv->invoice_number }} ({{ $inv->created_at->format('Y-m-d') }})</td>
                                    <td class="py-1 text-right text-red-500">{{ number_format($inv->balance_due, 2) }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                @endif

                <!-- Total Outstanding -->
                <div class="border-t pt-4">
                    <div class="flex justify-between items-center">
                        <span class="font-bold text-gray-800">Total Outstanding Balance</span>
                        <span class="font-bold text-red-600">LKR {{ number_format($customer->current_outstanding, 2) }}</span>
                    </div>
                </div>

                <!-- Footer -->
                <div class="mt-8 text-center text-xs text-gray-400">
                    <p>Thank you for your business!</p>
                    <p>Generated by {{ config('app.name') }} System</p>
                </div>

            </div>
            

        </div>
    </div>
</body>
</html>
