<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('My Stock') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-yellow-50 border-l-4 border-yellow-400 p-4">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <!-- Warning Icon -->
                        <svg class="h-5 w-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                        </svg>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm text-yellow-700">
                            {{ __("You are not currently assigned to any delivery vehicle.") }}
                        </p>
                        <p class="text-sm text-yellow-700 mt-2">
                            {{ __("Please wait for the administrator to assign a vehicle and load stock before you can view your inventory or process bills.") }}
                        </p>
                    </div>
                </div>
            </div>
            
            <div class="mt-6 flex justify-center">
                 <a href="{{ route('dashboard') }}" class="text-blue-600 hover:text-blue-900 underline">Return to Dashboard</a>
            </div>
        </div>
    </div>
</x-app-layout>
