<x-app-layout>
    <x-slot name="header">
        <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
            <div>
                <h2 class="font-bold text-2xl text-gray-900 leading-tight">
                    💰 My Salary & Payroll
                </h2>
                <p class="text-sm text-gray-600 mt-1">View your salary details, EPF/ETF, and payment history</p>
            </div>
            <a href="{{ route('sales.my-profile') }}" 
               class="inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white text-sm font-medium rounded-lg shadow-sm transition-all duration-200 hover:shadow-md">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                </svg>
                Update Bank Details
            </a>
        </div>
    </x-slot>

    <div class="py-6 sm:py-12">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            @if(session('success'))
                <div class="mb-6 bg-gradient-to-r from-green-50 to-emerald-50 border-l-4 border-green-500 text-green-800 px-4 py-3 rounded-lg shadow-sm animate-fade-in">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                        </svg>
                        {{ session('success') }}
                    </div>
                </div>
            @endif

            <!-- Quick Stats Cards -->
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 sm:gap-6 mb-6">
                <div class="bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl shadow-lg p-6 text-white transform transition-all duration-200 hover:scale-105">
                    <div class="flex items-center justify-between mb-2">
                        <div class="bg-white/20 backdrop-blur-sm p-3 rounded-lg">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                        </div>
                    </div>
                    <div class="text-sm opacity-90 mb-1">Basic Salary</div>
                    <div class="text-2xl font-bold">Rs. {{ number_format($user->basic_salary ?? 0, 0) }}</div>
                </div>

                <div class="bg-gradient-to-br from-purple-500 to-purple-600 rounded-xl shadow-lg p-6 text-white transform transition-all duration-200 hover:scale-105">
                    <div class="flex items-center justify-between mb-2">
                        <div class="bg-white/20 backdrop-blur-sm p-3 rounded-lg">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                            </svg>
                        </div>
                    </div>
                    <div class="text-sm opacity-90 mb-1">EPF Number</div>
                    <div class="text-lg font-bold truncate">{{ $user->epf_number ?? 'Not Set' }}</div>
                </div>

                <div class="bg-gradient-to-br from-indigo-500 to-indigo-600 rounded-xl shadow-lg p-6 text-white transform transition-all duration-200 hover:scale-105">
                    <div class="flex items-center justify-between mb-2">
                        <div class="bg-white/20 backdrop-blur-sm p-3 rounded-lg">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                            </svg>
                        </div>
                    </div>
                    <div class="text-sm opacity-90 mb-1">ETF Number</div>
                    <div class="text-lg font-bold truncate">{{ $user->etf_number ?? 'Not Set' }}</div>
                </div>

                <div class="bg-gradient-to-br from-green-500 to-green-600 rounded-xl shadow-lg p-6 text-white transform transition-all duration-200 hover:scale-105">
                    <div class="flex items-center justify-between mb-2">
                        <div class="bg-white/20 backdrop-blur-sm p-3 rounded-lg">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
                            </svg>
                        </div>
                    </div>
                    <div class="text-sm opacity-90 mb-1">Bank Account</div>
                    <div class="text-sm font-semibold truncate">
                        {{ $user->bank_name ?? 'Not Set' }}
                        @if($user->bank_account_number)
                            <div class="text-xs opacity-75 mt-1">{{ $user->bank_account_number }}</div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Current Month Payroll -->
            @if($currentPayroll)
            <div class="bg-gradient-to-br from-emerald-500 to-teal-600 rounded-2xl shadow-xl mb-6 overflow-hidden">
                <div class="p-6 sm:p-8">
                    <div class="flex items-center mb-6">
                        <div class="bg-white/20 backdrop-blur-sm p-3 rounded-xl mr-4">
                            <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 8h6m-5 0a3 3 0 110 6H9l3 3m-3-6h6m6 1a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                        </div>
                        <div class="flex-1">
                            <h3 class="text-xl sm:text-2xl font-bold text-white">Current Month Salary</h3>
                            <p class="text-emerald-100 text-sm mt-1">{{ \Carbon\Carbon::parse($currentPayroll->month)->format('F Y') }}</p>
                        </div>
                        <span class="px-3 py-1 rounded-full text-sm font-medium
                            {{ $currentPayroll->status === 'paid' ? 'bg-white text-emerald-700' : 
                               ($currentPayroll->status === 'processed' ? 'bg-blue-100 text-blue-800' : 'bg-yellow-100 text-yellow-800') }}">
                            {{ ucfirst($currentPayroll->status) }}
                        </span>
                    </div>
                    
                    <div class="grid grid-cols-2 lg:grid-cols-4 gap-4">
                        <div class="bg-white/10 backdrop-blur-sm rounded-xl p-4 border border-white/20">
                            <div class="text-sm text-emerald-100 mb-1">Gross Salary</div>
                            <div class="text-2xl font-bold text-white">Rs. {{ number_format($currentPayroll->gross_salary, 0) }}</div>
                        </div>
                        <div class="bg-white/10 backdrop-blur-sm rounded-xl p-4 border border-white/20">
                            <div class="text-sm text-emerald-100 mb-1">Deductions</div>
                            <div class="text-2xl font-bold text-red-200">Rs. {{ number_format($currentPayroll->total_deductions, 0) }}</div>
                        </div>
                        <div class="bg-white backdrop-blur-sm rounded-xl p-4 border border-emerald-300 lg:col-span-2">
                            <div class="text-sm text-emerald-700 mb-1 font-medium">Net Salary (Take Home)</div>
                            <div class="text-3xl font-bold text-emerald-700">Rs. {{ number_format($currentPayroll->net_salary, 0) }}</div>
                        </div>
                    </div>

                    <div class="mt-6">
                        @if($currentPayroll->id)
                        <a href="{{ route('sales.my-salary.show', $currentPayroll->id) }}" 
                           class="inline-flex items-center px-6 py-3 bg-white text-emerald-700 font-semibold rounded-xl hover:bg-emerald-50 transition-all duration-200 shadow-lg">
                            View Full Payslip
                            <svg class="w-5 h-5 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                            </svg>
                        </a>
                        @else
                        <div class="inline-flex items-center px-6 py-3 bg-white/20 text-white font-semibold rounded-xl backdrop-blur-sm">
                            <span>Projection (Not Finalized)</span>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
            @endif

            <!-- Payroll History -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 mb-6 overflow-hidden">
                <div class="p-4 sm:p-6 border-b border-gray-200 bg-gradient-to-r from-gray-50 to-white">
                    <h3 class="text-lg font-bold text-gray-900">📊 Payroll History</h3>
                    <p class="text-sm text-gray-600 mt-1">Your complete salary payment records</p>
                </div>
                
                <!-- Mobile Cards -->
                <div class="block lg:hidden">
                    @forelse($payrolls as $payroll)
                        <div class="border-b border-gray-200 p-4 hover:bg-gray-50 transition-colors">
                            <div class="flex items-start justify-between mb-3">
                                <div>
                                    <h4 class="font-semibold text-gray-900">{{ \Carbon\Carbon::parse($payroll->month)->format('F Y') }}</h4>
                                    <p class="text-xs text-gray-500">Payment: {{ $payroll->payment_date->format('M d, Y') }}</p>
                                </div>
                                <span class="px-2 py-1 text-xs rounded-full font-medium
                                    {{ $payroll->status === 'paid' ? 'bg-green-100 text-green-800' : 
                                       ($payroll->status === 'processed' ? 'bg-blue-100 text-blue-800' : 'bg-yellow-100 text-yellow-800') }}">
                                    {{ ucfirst($payroll->status) }}
                                </span>
                            </div>

                            <div class="grid grid-cols-2 gap-3 mb-3">
                                <div class="bg-blue-50 rounded-lg p-3">
                                    <p class="text-xs text-blue-600 font-medium">Gross</p>
                                    <p class="text-lg font-bold text-blue-900">Rs. {{ number_format($payroll->gross_salary, 0) }}</p>
                                </div>
                                <div class="bg-green-50 rounded-lg p-3">
                                    <p class="text-xs text-green-600 font-medium">Net</p>
                                    <p class="text-lg font-bold text-green-900">Rs. {{ number_format($payroll->net_salary, 0) }}</p>
                                </div>
                            </div>

                            <div class="space-y-2 text-sm mb-3">
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Basic:</span>
                                    <span class="font-medium">Rs. {{ number_format($payroll->basic_salary, 0) }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Commission:</span>
                                    <span class="font-medium">Rs. {{ number_format($payroll->total_commission, 0) }}</span>
                                </div>
                                <div class="flex justify-between text-red-600">
                                    <span>Total Deductions:</span>
                                    <span class="font-medium">Rs. {{ number_format($payroll->total_deductions, 0) }}</span>
                                </div>
                            </div>

                            <a href="{{ route('sales.my-salary.show', $payroll->id) }}" 
                               class="block w-full text-center px-4 py-2 bg-blue-50 text-blue-700 rounded-lg hover:bg-blue-100 transition-colors text-sm font-medium">
                                View Details
                            </a>
                        </div>
                    @empty
                        <div class="p-12 text-center">
                            <svg class="w-16 h-16 mx-auto text-gray-300 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                            </svg>
                            <p class="text-gray-500">No payroll records found</p>
                        </div>
                    @endforelse
                </div>

                <!-- Desktop Table -->
                <div class="hidden lg:block overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Month</th>
                                <th class="px-4 py-3 text-right text-xs font-semibold text-gray-600 uppercase tracking-wider">Basic</th>
                                <th class="px-4 py-3 text-right text-xs font-semibold text-gray-600 uppercase tracking-wider">Commission</th>
                                <th class="px-4 py-3 text-right text-xs font-semibold text-gray-600 uppercase tracking-wider">Gross</th>
                                <th class="px-4 py-3 text-right text-xs font-semibold text-gray-600 uppercase tracking-wider">EPF (8%)</th>
                                <th class="px-4 py-3 text-right text-xs font-semibold text-gray-600 uppercase tracking-wider">ETF (3%)</th>
                                <th class="px-4 py-3 text-right text-xs font-semibold text-gray-600 uppercase tracking-wider">Deductions</th>
                                <th class="px-4 py-3 text-right text-xs font-semibold text-gray-600 uppercase tracking-wider">Net Salary</th>
                                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Status</th>
                                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @forelse($payrolls as $payroll)
                                <tr class="hover:bg-blue-50/30 transition-colors">
                                    <td class="px-4 py-4 font-medium">{{ \Carbon\Carbon::parse($payroll->month)->format('F Y') }}</td>
                                    <td class="px-4 py-4 text-right">Rs. {{ number_format($payroll->basic_salary, 0) }}</td>
                                    <td class="px-4 py-4 text-right">Rs. {{ number_format($payroll->total_commission, 0) }}</td>
                                    <td class="px-4 py-4 text-right font-bold text-blue-600">Rs. {{ number_format($payroll->gross_salary, 0) }}</td>
                                    <td class="px-4 py-4 text-right text-red-600">Rs. {{ number_format($payroll->epf_employee, 0) }}</td>
                                    <td class="px-4 py-4 text-right text-red-600">Rs. {{ number_format($payroll->etf_employee, 0) }}</td>
                                    <td class="px-4 py-4 text-right font-semibold text-red-600">Rs. {{ number_format($payroll->total_deductions, 0) }}</td>
                                    <td class="px-4 py-4 text-right font-bold text-green-600 text-lg">Rs. {{ number_format($payroll->net_salary, 0) }}</td>
                                    <td class="px-4 py-4">
                                        <span class="px-3 py-1 text-xs font-medium rounded-full 
                                            {{ $payroll->status === 'paid' ? 'bg-green-100 text-green-800' : 
                                               ($payroll->status === 'processed' ? 'bg-blue-100 text-blue-800' : 'bg-yellow-100 text-yellow-800') }}">
                                            {{ ucfirst($payroll->status) }}
                                        </span>
                                    </td>
                                    <td class="px-4 py-4">
                                        <a href="{{ route('sales.my-salary.show', $payroll->id) }}" 
                                           class="text-blue-600 hover:text-blue-800 text-sm font-medium hover:underline">
                                            👁️ View Details
                                        </a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="10" class="px-4 py-12 text-center">
                                        <svg class="w-16 h-16 mx-auto text-gray-300 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                        </svg>
                                        <p class="text-gray-500 text-lg">No payroll records found</p>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <div class="p-4 border-t border-gray-200">
                    {{ $payrolls->links() }}
                </div>
            </div>

            <!-- Advances & Loans -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                <!-- Salary Advances -->
                <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
                    <div class="p-4 sm:p-6 border-b border-gray-200 bg-gradient-to-r from-purple-50 to-white">
                        <h3 class="text-lg font-bold text-gray-900">💵 My Salary Advances</h3>
                        <p class="text-sm text-gray-600 mt-1">Track your salary advance deductions</p>
                    </div>
                    <div class="p-4 sm:p-6">
                        @forelse($salaryAdvances as $advance)
                            <div class="border-b border-gray-200 pb-4 mb-4 last:border-0 last:pb-0 last:mb-0">
                                <div class="flex justify-between items-start">
                                    <div>
                                        <div class="font-bold text-lg text-gray-900">Rs. {{ number_format($advance->amount, 0) }}</div>
                                        <div class="text-sm text-gray-600">{{ $advance->advance_date->format('M d, Y') }}</div>
                                        @if($advance->reason)
                                            <div class="text-xs text-gray-500 mt-1 bg-gray-50 px-2 py-1 rounded inline-block">{{ $advance->reason }}</div>
                                        @endif
                                    </div>
                                    <div class="text-right">
                                        <span class="px-2 py-1 text-xs rounded-full font-medium
                                            {{ $advance->status === 'fully_deducted' ? 'bg-green-100 text-green-800' : 
                                               ($advance->status === 'partially_deducted' ? 'bg-yellow-100 text-yellow-800' : 'bg-blue-100 text-blue-800') }}">
                                            {{ ucfirst(str_replace('_', ' ', $advance->status)) }}
                                        </span>
                                        <div class="text-sm text-gray-600 mt-2">
                                            <span class="text-xs text-gray-500">Remaining:</span><br>
                                            <span class="font-bold text-orange-600">Rs. {{ number_format($advance->remaining_amount, 0) }}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @empty
                            <div class="text-center py-8">
                                <svg class="w-12 h-12 mx-auto text-gray-300 mb-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                <p class="text-gray-500 text-sm">No salary advances</p>
                            </div>
                        @endforelse
                    </div>
                </div>

                <!-- Loans -->
                <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
                    <div class="p-4 sm:p-6 border-b border-gray-200 bg-gradient-to-r from-indigo-50 to-white">
                        <h3 class="text-lg font-bold text-gray-900">🏦 My Loans</h3>
                        <p class="text-sm text-gray-600 mt-1">Track your loan repayment progress</p>
                    </div>
                    <div class="p-4 sm:p-6">
                        @forelse($loans as $loan)
                            <div class="border-b border-gray-200 pb-4 mb-4 last:border-0 last:pb-0 last:mb-0">
                                <div class="flex justify-between items-start mb-3">
                                    <div>
                                        <div class="font-bold text-lg text-gray-900">Rs. {{ number_format($loan->total_amount, 0) }}</div>
                                        <div class="text-sm text-gray-600">{{ $loan->loan_date->format('M d, Y') }}</div>
                                        <div class="text-xs text-gray-500 mt-1">
                                            Monthly: Rs. {{ number_format($loan->monthly_installment, 0) }}
                                        </div>
                                        @if($loan->purpose)
                                            <div class="text-xs text-gray-500 mt-1 bg-gray-50 px-2 py-1 rounded inline-block">{{ $loan->purpose }}</div>
                                        @endif
                                    </div>
                                    <div class="text-right">
                                        <span class="px-2 py-1 text-xs rounded-full font-medium
                                            {{ $loan->status === 'completed' ? 'bg-green-100 text-green-800' : 
                                               ($loan->status === 'active' ? 'bg-blue-100 text-blue-800' : 'bg-gray-100 text-gray-800') }}">
                                            {{ ucfirst($loan->status) }}
                                        </span>
                                    </div>
                                </div>
                                <div class="mb-2">
                                    <div class="flex justify-between text-xs text-gray-600 mb-1">
                                        <span>{{ $loan->paid_installments }}/{{ $loan->total_installments }} installments paid</span>
                                        <span>{{ round(($loan->paid_installments / $loan->total_installments) * 100) }}%</span>
                                    </div>
                                    <div class="w-full bg-gray-200 rounded-full h-2">
                                        <div class="bg-gradient-to-r from-blue-500 to-indigo-600 h-2 rounded-full transition-all duration-500" 
                                             style="width: {{ ($loan->paid_installments / $loan->total_installments) * 100 }}%"></div>
                                    </div>
                                </div>
                                <div class="text-sm text-gray-600">
                                    <span class="text-xs text-gray-500">Remaining:</span>
                                    <span class="font-bold text-orange-600">Rs. {{ number_format($loan->remaining_amount, 0) }}</span>
                                </div>
                            </div>
                        @empty
                            <div class="text-center py-8">
                                <svg class="w-12 h-12 mx-auto text-gray-300 mb-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path>
                                </svg>
                                <p class="text-gray-500 text-sm">No loans</p>
                            </div>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        @keyframes fade-in {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .animate-fade-in {
            animation: fade-in 0.3s ease-out;
        }
    </style>
</x-app-layout>
