<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\Admin\DashboardController as AdminDashboard;
use App\Http\Controllers\Sales\BillingController;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;

Route::get('/', function () {
    return redirect()->route('login');
});




Route::get('/invoice/{token}', [App\Http\Controllers\PublicInvoiceController::class, 'show'])->name('public.invoice.show');
Route::get('/receipt/{token}', [App\Http\Controllers\PublicReceiptController::class, 'show'])->name('public.receipt.show');

Route::get('/setup-commissions', function() {
    $reps = \App\Models\User::whereHas('role', function($q) {
        $q->where('name', 'Sales Representative');
    })->get();

    $output = "";
    foreach ($reps as $rep) {
        $rep->commission_cash = 5.0;
        $rep->commission_credit = 2.0;
        $rep->commission_cheque = 2.0;
        $rep->save();
        $output .= "Updated {$rep->name}: Cash 5%, Credit 2%, Cheque 2%<br>";
    }
    return $output . "Done. Please try collecting payment again.";
});
Route::get('/dashboard', function () {
    $user = Auth::user();
    if ($user->isAdmin()) {
        return redirect()->route('admin.dashboard');
    }
    if ($user->isSalesRep()) {
        // Remove redirect to billing so they can see dashboard
        return app(\App\Http\Controllers\Sales\RepDashboardController::class)->index();
    }
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

Route::middleware(['auth', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', [AdminDashboard::class, 'index'])->name('dashboard');
    // Product Management
    Route::resource('products', \App\Http\Controllers\Admin\ProductController::class);
    
    // Inventory & GRN
    Route::get('/inventory', [App\Http\Controllers\Admin\InventoryController::class, 'index'])->name('inventory.index');
    Route::get('/inventory/grn', [App\Http\Controllers\Admin\InventoryController::class, 'grnIndex'])->name('inventory.grn.index');
    Route::get('/inventory/grn/create', [App\Http\Controllers\Admin\InventoryController::class, 'grnCreate'])->name('inventory.grn.create');
    Route::post('/inventory/grn', [App\Http\Controllers\Admin\InventoryController::class, 'grnStore'])->name('inventory.grn.store');

    // Admin Management Routes
    Route::resource('reps', \App\Http\Controllers\Admin\SalesRepController::class);
    Route::resource('vehicles', \App\Http\Controllers\Admin\VehicleController::class);
    
    // Truck Loading
    Route::get('/stock-transfer/create', [App\Http\Controllers\Admin\StockTransferController::class, 'create'])->name('stock-transfer.create');
    Route::post('/stock-transfer', [App\Http\Controllers\Admin\StockTransferController::class, 'store'])->name('stock-transfer.store');

    // Admin Expense Approval
    Route::get('/expenses', [App\Http\Controllers\Admin\ExpenseController::class, 'index'])->name('expenses.index');
    Route::post('/expenses/{expense}/status', [App\Http\Controllers\Admin\ExpenseController::class, 'updateStatus'])->name('expenses.update-status');

    // Route::resource('products', ProductController::class);
    // Route::resource('customers', CustomerController::class);
    // Vehicle Stocks
    Route::get('/vehicle-stocks', [App\Http\Controllers\Admin\AdminStockController::class, 'index'])->name('vehicle-stocks.index');

    // Delivery Management
    Route::resource('deliveries', \App\Http\Controllers\Admin\DeliveryController::class);
    Route::post('/deliveries/{delivery}/start', [\App\Http\Controllers\Admin\DeliveryController::class, 'start'])->name('deliveries.start');
    Route::post('/deliveries/{delivery}/end', [\App\Http\Controllers\Admin\DeliveryController::class, 'end'])->name('deliveries.end');
    Route::get('/deliveries/{delivery}/unload', [\App\Http\Controllers\Admin\DeliveryController::class, 'unloadForm'])->name('deliveries.unload-form');
    Route::post('/deliveries/{delivery}/unload', [\App\Http\Controllers\Admin\DeliveryController::class, 'unload'])->name('deliveries.unload');

    // Reports
    Route::get('/reports/sales-summary', [App\Http\Controllers\Admin\ReportController::class, 'salesSummary'])->name('reports.sales-summary');
    Route::get('/reports/due-balances', [App\Http\Controllers\Admin\ReportController::class, 'dueBalances'])->name('reports.due-balances');
    Route::get('/reports/commissions', [App\Http\Controllers\Admin\ReportController::class, 'commissions'])->name('reports.commissions');
    Route::get('/reports/cheques', [App\Http\Controllers\Admin\ReportController::class, 'cheques'])->name('reports.cheques');
    Route::post('/reports/cheques/{id}/status', [App\Http\Controllers\Admin\ReportController::class, 'updateChequeStatus'])->name('reports.cheques.update-status');

    Route::get('/reports/cash-collections', [App\Http\Controllers\Admin\ReportController::class, 'cashCollections'])->name('reports.cash-collections');
    Route::post('/reports/cash-collections/remit', [App\Http\Controllers\Admin\ReportController::class, 'markRemitted'])->name('reports.cash-collections.remit');
    
    // Payroll
    Route::get('/payroll', [App\Http\Controllers\Admin\PayrollController::class, 'index'])->name('payroll.index');
    Route::post('/payroll/generate', [App\Http\Controllers\Admin\PayrollController::class, 'generate'])->name('payroll.generate');
    Route::get('/payroll/{id}', [App\Http\Controllers\Admin\PayrollController::class, 'show'])->name('payroll.show');
    Route::post('/payroll/{id}/mark-paid', [App\Http\Controllers\Admin\PayrollController::class, 'markAsPaid'])->name('payroll.mark-paid');
    Route::post('/payroll/{id}/update-basic', [App\Http\Controllers\Admin\PayrollController::class, 'updateBasicSalary'])->name('payroll.update-basic');
    Route::post('/payroll/{id}/update-details', [App\Http\Controllers\Admin\PayrollController::class, 'updateEmployeeDetails'])->name('payroll.update-details');
    Route::post('/payroll/{id}/recalculate', [App\Http\Controllers\Admin\PayrollController::class, 'recalculate'])->name('payroll.recalculate');
    
    // Salary Advances
    Route::resource('salary-advances', App\Http\Controllers\Admin\SalaryAdvanceController::class);
    
    // Loans
    Route::resource('loans', App\Http\Controllers\Admin\LoanController::class);
    Route::post('/loans/{id}/cancel', [App\Http\Controllers\Admin\LoanController::class, 'cancel'])->name('loans.cancel');
});

Route::middleware(['auth', 'sales_rep'])->prefix('sales')->name('sales.')->group(function () {
    // Billing Routes
    Route::get('/billing', [BillingController::class, 'index'])->name('billing');
    Route::post('/billing', [BillingController::class, 'store'])->name('billing.store');
    Route::get('/billing/print/{id}', [BillingController::class, 'print'])->name('billing.print');
    
    // Customer Management (New Flow)
    Route::get('/customers', [App\Http\Controllers\Sales\CustomerController::class, 'index'])->name('customers.index');
    Route::get('/customers/create', [App\Http\Controllers\Sales\CustomerController::class, 'create'])->name('customers.create');
    Route::post('/customers', [App\Http\Controllers\Sales\CustomerController::class, 'store'])->name('customers.store');
    Route::get('/customers/{customer}', [App\Http\Controllers\Sales\CustomerController::class, 'show'])->name('customers.show');
    
    // Payments / Settlement
    Route::get('/payments', [App\Http\Controllers\Sales\PaymentController::class, 'index'])->name('payments.index');
    Route::get('/payments/create', [App\Http\Controllers\Sales\PaymentController::class, 'create'])->name('payments.create');
    Route::post('/payments', [App\Http\Controllers\Sales\PaymentController::class, 'store'])->name('payments.store');
    Route::get('/payments/receipt', [App\Http\Controllers\Sales\PaymentController::class, 'receipt'])->name('payments.receipt');
    
    // Other Sales Rep Routes
    Route::get('/my-stock', [App\Http\Controllers\Sales\MyStockController::class, 'index'])->name('my-stock.index');

    Route::get('/expenses', [App\Http\Controllers\Sales\MyExpenseController::class, 'index'])->name('expenses.index');
    Route::get('/expenses/create', [App\Http\Controllers\Sales\MyExpenseController::class, 'create'])->name('expenses.create');
    Route::post('/expenses', [App\Http\Controllers\Sales\MyExpenseController::class, 'store'])->name('expenses.store');

    Route::get('/my-commissions', [App\Http\Controllers\Sales\CommissionController::class, 'index'])->name('my-commissions.index');
    
    // Salary & Payroll
    Route::get('/my-salary', [App\Http\Controllers\SalesRep\SalaryController::class, 'index'])->name('my-salary.index');
    Route::get('/my-salary/{id}', [App\Http\Controllers\SalesRep\SalaryController::class, 'show'])->name('my-salary.show');
    Route::get('/my-profile', [App\Http\Controllers\SalesRep\SalaryController::class, 'profile'])->name('my-profile');
    Route::post('/my-profile', [App\Http\Controllers\SalesRep\SalaryController::class, 'updateProfile'])->name('my-profile.update');
});



require __DIR__.'/auth.php';
