<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
                <?php echo e(__('Delivery Details')); ?> #<?php echo e($delivery->id); ?>

            </h2>
            <span class="px-3 py-1 rounded-full text-sm font-semibold 
                <?php if($delivery->status === 'completed'): ?> bg-green-100 text-green-800 
                <?php elseif($delivery->status === 'ongoing'): ?> bg-yellow-100 text-yellow-800 
                <?php elseif($delivery->status === 'unloading'): ?> bg-purple-100 text-purple-800
                <?php else: ?> bg-blue-100 text-blue-800 <?php endif; ?>">
                <?php echo e(ucfirst($delivery->status)); ?>

            </span>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-6">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <!-- Trip Info -->
                <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow border border-gray-200 dark:border-gray-700">
                    <h3 class="text-lg font-medium text-gray-900 dark:text-white mb-4">Trip Information</h3>
                    <div class="space-y-3 text-sm">
                        <div class="flex justify-between">
                            <span class="text-gray-500">Truck:</span>
                            <span class="font-bold text-indigo-600 dark:text-indigo-400"><?php echo e($delivery->vehicle->truck_number); ?></span>
                        </div>
                        <div class="flex justify-between border-t dark:border-gray-700 pt-2">
                            <span class="text-gray-500">Driver:</span>
                            <span class="font-medium text-gray-900 dark:text-white"><?php echo e($delivery->driver->name); ?></span>
                        </div>
                        <div class="flex justify-between border-t dark:border-gray-700 pt-2">
                            <span class="text-gray-500">Sales Rep:</span>
                            <span class="font-medium text-gray-900 dark:text-white"><?php echo e($delivery->salesRep->name); ?></span>
                        </div>
                        <div class="flex justify-between border-t dark:border-gray-700 pt-2">
                            <span class="text-gray-500">Started:</span>
                            <span class="text-gray-900 dark:text-white"><?php echo e($delivery->started_at ? $delivery->started_at->format('M d, Y H:i') : 'N/A'); ?></span>
                        </div>
                        <div class="flex justify-between border-t dark:border-gray-700 pt-2">
                            <span class="text-gray-500">Ended:</span>
                            <span class="text-gray-900 dark:text-white"><?php echo e($delivery->ended_at ? $delivery->ended_at->format('M d, Y H:i') : 'N/A'); ?></span>
                        </div>
                    </div>
                </div>

                <!-- Summary Stats -->
                <div class="md:col-span-2 bg-white dark:bg-gray-800 p-6 rounded-lg shadow border border-gray-200 dark:border-gray-700">
                    <h3 class="text-lg font-medium text-gray-900 dark:text-white mb-4">Goods Summary</h3>
                    <div class="overflow-x-auto">
                        <table class="w-full text-sm text-left">
                            <thead class="bg-gray-50 dark:bg-gray-700 text-gray-600 dark:text-gray-400 uppercase text-xs">
                                <tr>
                                    <th class="px-4 py-2">Product</th>
                                    <th class="px-4 py-2 text-center">Loaded</th>
                                    <th class="px-4 py-2 text-center">Unloaded (Sys)</th>
                                    <th class="px-4 py-2 text-center">Physical</th>
                                    <th class="px-4 py-2 text-center">Sold</th>
                                    <th class="px-4 py-2 text-center">Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $delivery->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        // Sold = Loaded - Unloaded (Sys)
                                        $sold = $item->loaded_quantity - ($item->unloaded_quantity ?? 0);
                                        $discrepancy = $item->unloaded_quantity !== null && $item->unloaded_quantity != $item->physical_unloaded_quantity;
                                    ?>
                                    <tr class="border-b dark:border-gray-700">
                                        <td class="px-4 py-3 font-medium"><?php echo e($item->product->name); ?></td>
                                        <td class="px-4 py-3 text-center"><?php echo e($item->loaded_quantity); ?></td>
                                        <td class="px-4 py-3 text-center"><?php echo e($item->unloaded_quantity ?? '---'); ?></td>
                                        <td class="px-4 py-3 text-center <?php echo e($discrepancy ? 'text-red-600 font-bold' : ''); ?>">
                                            <?php echo e($item->physical_unloaded_quantity ?? '---'); ?>

                                        </td>
                                        <td class="px-4 py-3 text-center font-bold text-green-600">
                                            <?php echo e($delivery->status === 'completed' || $delivery->status === 'unloading' ? $sold : '---'); ?>

                                        </td>
                                        <td class="px-4 py-3 text-center">
                                            <?php if($discrepancy): ?>
                                                <span class="text-xs bg-red-100 text-red-800 px-2 py-0.5 rounded-full">Error</span>
                                            <?php elseif($item->unloaded_quantity !== null): ?>
                                                <span class="text-xs bg-green-100 text-green-800 px-2 py-0.5 rounded-full">OK</span>
                                            <?php else: ?>
                                                <span class="text-xs bg-gray-100 text-gray-800 px-2 py-0.5 rounded-full">Pending</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="flex justify-between">
                <a href="<?php echo e(route('admin.deliveries.index')); ?>" class="inline-flex items-center px-4 py-2 bg-gray-200 text-gray-700 rounded-md hover:bg-gray-300">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path></svg>
                    Back to List
                </a>

                <?php if($delivery->status === 'unloading'): ?>
                    <a href="<?php echo e(route('admin.deliveries.unload-form', $delivery)); ?>" class="inline-flex items-center px-6 py-2 bg-purple-600 text-white rounded-md hover:bg-purple-700">
                        Proceed to Unloading & Verification
                    </a>
                <?php endif; ?>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\Users\kavishka\Desktop\laravel\bulkLkDeliver\resources\views/admin/deliveries/show.blade.php ENDPATH**/ ?>