<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            <?php echo e(__('Collect Payment')); ?>

        </h2>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <form action="<?php echo e(route('sales.payments.store')); ?>" method="POST" enctype="multipart/form-data" x-data="{ method: 'Cash' }">
                        <?php echo csrf_field(); ?>
                        
                        <!-- Customer Selection -->
                        <div class="mb-4">
                            <label class="block text-gray-700 text-sm font-bold mb-2">Customer</label>
                            <?php if($selectedCustomer): ?>
                                <input type="hidden" name="customer_id" value="<?php echo e($selectedCustomer->id); ?>">
                                <div class="p-4 bg-gray-50 border rounded shadow-sm">
                                    <div class="text-lg font-bold"><?php echo e($selectedCustomer->name); ?></div>
                                    <div class="text-sm text-gray-600"><?php echo e($selectedCustomer->address); ?></div>
                                    <div class="mt-2 text-xl font-bold text-red-600">
                                        Total Due: LKR <?php echo e(number_format($selectedCustomer->outstanding, 2)); ?>

                                    </div>
                                    
                                    <!-- List of Invoices -->
                                    <div class="mt-4">
                                        <h4 class="text-xs font-bold uppercase text-gray-500 mb-2">Unpaid Invoices (FIFO)</h4>
                                        <ul class="text-sm border-t">
                                            <?php $__currentLoopData = $selectedCustomer->sales->where('balance_due', '>', 0.01); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li class="flex justify-between py-2 border-b">
                                                    <span><?php echo e($sale->invoice_number); ?> (<?php echo e($sale->created_at->format('Y-m-d')); ?>)</span>
                                                    <span class="font-bold">LKR <?php echo e(number_format($sale->balance_due, 2)); ?></span>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </div>
                                </div>
                            <?php else: ?>
                                <select name="customer_id" class="w-full border-gray-300 rounded shadow-sm" onchange="window.location.href='<?php echo e(route('sales.payments.create')); ?>?customer_id='+this.value">
                                    <option value="">-- Select Customer --</option>
                                    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($c->id); ?>"><?php echo e($c->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            <?php endif; ?>
                        </div>

                        <!-- Payment Details -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-gray-700 text-sm font-bold mb-2">Amount (LKR)</label>
                                <input type="number" step="0.01" name="amount" class="w-full border-gray-300 rounded shadow-sm" required placeholder="0.00" value="<?php echo e(old('amount')); ?>">
                            </div>
                            <div>
                                <label class="block text-gray-700 text-sm font-bold mb-2">Method</label>
                                <select name="method" x-model="method" class="w-full border-gray-300 rounded shadow-sm">
                                    <option value="Cash">Cash</option>
                                    <option value="Cheque">Cheque</option>
                                </select>
                            </div>
                        </div>

                        <!-- Cheque Details -->
                        <div class="mt-4 p-4 bg-gray-50 border border-gray-200 rounded" x-show="method === 'Cheque'" style="display: none;">
                            <h4 class="font-bold text-sm text-gray-700 mb-3 border-b pb-1">Cheque Details</h4>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label class="block text-xs font-bold text-gray-600">Bank Name</label>
                                    <input type="text" name="bank_name" class="w-full border-gray-300 rounded text-sm" placeholder="e.g. BOC">
                                </div>
                                <div>
                                    <label class="block text-xs font-bold text-gray-600">Cheque Number</label>
                                    <input type="text" name="cheque_number" class="w-full border-gray-300 rounded text-sm" placeholder="XXXXXX">
                                </div>
                                <div>
                                    <label class="block text-xs font-bold text-gray-600">Cheque Date (Filled Date)</label>
                                    <input type="date" name="cheque_date" class="w-full border-gray-300 rounded text-sm">
                                </div>
                                <div>
                                    <label class="block text-xs font-bold text-gray-600">Cheque Image</label>
                                    <input type="file" name="cheque_image" accept="image/*" class="w-full border bg-white rounded text-sm p-1">
                                </div>
                            </div>
                        </div>

                        <div class="mt-4">
                            <label class="block text-gray-700 text-sm font-bold mb-2">Reference / Note</label>
                            <input type="text" name="reference" class="w-full border-gray-300 rounded shadow-sm" placeholder="Remarks">
                        </div>

                        <div class="mt-6 flex justify-end">
                            <a href="<?php echo e(route('sales.payments.index')); ?>" class="text-gray-600 mr-4 self-center text-sm">Cancel</a>
                            <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded shadow hover:bg-blue-700 font-bold">
                                Save Payment
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\Users\kavishka\Desktop\laravel\bulkLkDeliver\resources\views/sales/payments/create.blade.php ENDPATH**/ ?>