<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-bold text-2xl text-gray-800 dark:text-gray-200 leading-tight">
            <?php echo e(__('Customer Due Balances')); ?>

        </h2>
     <?php $__env->endSlot(); ?>

    <div class="py-12 bg-gray-50 dark:bg-gray-900 min-h-screen">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-6">
            
            <!-- Report Tabs -->
            <div class="flex space-x-4 px-4 sm:px-0">
                <a href="<?php echo e(route('admin.reports.due-balances')); ?>" class="px-6 py-3 rounded-xl font-bold transition-all <?php echo e(request()->routeIs('admin.reports.due-balances') ? 'bg-indigo-600 text-white shadow-lg shadow-indigo-200' : 'bg-white text-gray-600 hover:bg-gray-100'); ?>">
                    Customer Due Balances
                </a>
                <a href="<?php echo e(route('admin.reports.commissions')); ?>" class="px-6 py-3 rounded-xl font-bold transition-all <?php echo e(request()->routeIs('admin.reports.commissions') ? 'bg-indigo-600 text-white shadow-lg shadow-indigo-200' : 'bg-white text-gray-600 hover:bg-gray-100'); ?>">
                    Sales Rep Commissions
                </a>
            </div>

            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-2xl">
                <div class="p-8">
                    <div class="overflow-x-auto">
                        <table class="w-full text-left border-collapse">
                            <thead>
                                <tr class="bg-gray-100 dark:bg-gray-700 text-gray-700 dark:text-gray-200">
                                    <th class="p-4 rounded-tl-xl">Customer Name</th>
                                    <th class="p-4">Area</th>
                                    <th class="p-4">Sales Rep</th>
                                    <th class="p-4 text-right">Credit Limit</th>
                                    <th class="p-4 text-right rounded-tr-xl">Total Due Balance</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-200 dark:divide-gray-700">
                                <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="hover:bg-gray-50 dark:hover:bg-gray-700/50 transition-colors">
                                        <td class="p-4">
                                            <div class="font-semibold text-gray-900 dark:text-white"><?php echo e($customer->name); ?></div>
                                            <div class="text-xs text-gray-500"><?php echo e($customer->mobile); ?></div>
                                        </td>
                                        <td class="p-4 text-gray-600 dark:text-gray-400"><?php echo e($customer->area ?? 'N/A'); ?></td>
                                        <td class="p-4 text-gray-600 dark:text-gray-400">
                                            <?php echo e($customer->salesRep ? $customer->salesRep->name : 'Unassigned'); ?>

                                        </td>
                                        <td class="p-4 text-right text-gray-600 dark:text-gray-400">
                                            <?php echo e(number_format($customer->credit_limit, 2)); ?>

                                        </td>
                                        <td class="p-4 text-right font-bold <?php echo e($customer->total_due > 0 ? 'text-red-600' : 'text-green-600'); ?>">
                                            <?php echo e(number_format($customer->total_due, 2)); ?>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            <tfoot class="bg-gray-50 dark:bg-gray-800 font-bold border-t-2 border-gray-200 dark:border-gray-600">
                                <tr>
                                    <td colspan="4" class="p-4 text-right text-gray-700 dark:text-gray-200">Grand Total Due:</td>
                                    <td class="p-4 text-right text-red-600">
                                        <?php echo e(number_format($customers->sum('total_due'), 2)); ?>

                                    </td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\Users\kavishka\Desktop\laravel\bulkLkDeliver\resources\views/admin/reports/due_balances.blade.php ENDPATH**/ ?>