<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            <?php echo e(__('Cheque Management')); ?>

        </h2>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    
                    <?php if(session('success')): ?>
                        <div class="mb-4 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative">
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>

                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                                    <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Customer</th>
                                    <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Details</th>
                                    <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                                    <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Image</th>
                                    <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                    <th class="px-3 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                <?php $__empty_1 = true; $__currentLoopData = $cheques; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cheque): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr class="<?php if($cheque->cheque_status == 'returned'): ?> bg-red-50 <?php elseif($cheque->cheque_status == 'cleared'): ?> bg-green-50 <?php endif; ?>">
                                        <td class="px-3 py-4 text-xs whitespace-nowrap">
                                            <div class="font-bold"><?php echo e($cheque->created_at->format('Y-m-d')); ?></div>
                                            <div class="text-gray-500">Filled: <?php echo e($cheque->cheque_date ? \Carbon\Carbon::parse($cheque->cheque_date)->format('Y-m-d') : '-'); ?></div>
                                        </td>
                                        <td class="px-3 py-4 text-xs">
                                            <div class="font-bold"><?php echo e($cheque->customer->name); ?></div>
                                            <div class="text-gray-500"><?php echo e($cheque->customer->area); ?></div>
                                            <div class="text-xs text-blue-500">Rep: <?php echo e($cheque->collector->name ?? 'N/A'); ?></div>
                                        </td>
                                        <td class="px-3 py-4 text-xs">
                                            <div>Bank: <?php echo e($cheque->bank_name ?? 'N/A'); ?></div>
                                            <div>No: <?php echo e($cheque->cheque_number ?? 'N/A'); ?></div>
                                        </td>
                                        <td class="px-3 py-4 text-xs font-bold text-gray-900">
                                            LKR <?php echo e(number_format($cheque->amount, 2)); ?>

                                        </td>
                                        <td class="px-3 py-4 text-xs">
                                            <?php if($cheque->cheque_image_path): ?>
                                                <a href="<?php echo e(asset('storage/'.$cheque->cheque_image_path)); ?>" target="_blank" class="text-blue-600 hover:underline">View</a>
                                            <?php else: ?>
                                                <span class="text-gray-400">None</span>
                                            <?php endif; ?>
                                        </td>
                                        <td class="px-3 py-4 text-xs">
                                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                                                <?php if($cheque->cheque_status == 'cleared'): ?> bg-green-100 text-green-800 
                                                <?php elseif($cheque->cheque_status == 'returned'): ?> bg-red-100 text-red-800 
                                                <?php else: ?> bg-yellow-100 text-yellow-800 <?php endif; ?>">
                                                <?php echo e(ucfirst($cheque->cheque_status)); ?>

                                            </span>
                                            
                                            <!-- Notification Logic for 2 days due -->
                                            <?php
                                                $filledDate = \Carbon\Carbon::parse($cheque->cheque_date);
                                                $isOverdue = $filledDate->addDays(2)->isPast() && $cheque->cheque_status == 'pending';
                                            ?>
                                            <?php if($isOverdue): ?>
                                                <div class="text-red-600 font-bold mt-1 text-[10px] animate-pulse">Action Required</div>
                                            <?php endif; ?>
                                        </td>
                                        <td class="px-3 py-4 text-xs text-right whitespace-nowrap">
                                            <?php if($cheque->cheque_status == 'pending'): ?>
                                                <div class="flex flex-col space-y-1 items-end">
                                                    <form action="<?php echo e(route('admin.reports.cheques.update-status', $cheque->id)); ?>" method="POST">
                                                        <?php echo csrf_field(); ?>
                                                        <input type="hidden" name="status" value="cleared">
                                                        <button type="submit" class="text-green-600 hover:text-green-900 font-bold">Mark Cleared</button>
                                                    </form>
                                                    <form action="<?php echo e(route('admin.reports.cheques.update-status', $cheque->id)); ?>" method="POST">
                                                        <?php echo csrf_field(); ?>
                                                        <input type="hidden" name="status" value="returned">
                                                        <button type="submit" class="text-red-600 hover:text-red-900 font-bold">Mark Returned</button>
                                                    </form>
                                                </div>
                                            <?php else: ?>
                                                <span class="text-gray-400">Locked</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="7" class="px-6 py-4 text-center text-gray-500">No cheques found.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                        <div class="mt-4">
                            <?php echo e($cheques->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\Users\kavishka\Desktop\laravel\bulkLkDeliver\resources\views/admin/reports/cheques.blade.php ENDPATH**/ ?>